/*
 * Copyright (C) 2014 Torsten Maehne, Universit Pierre et Marie Curie
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
//
// PROJECT NAME: vibration_sensor_dvcon14
//
// LIBRARY NAME: sensor
//
// MODULE NAME:  vibration_sensor
//
// DESCRIPTION OF MODULE:
//      Vibration sensor
//
// DESCRIPTION OF PORTS:           (please see header)
// DESCRIPTION OF PARAMETER:       (please see header)
//
// this file was generated by 'sca_xml2cpp.xsl' StyleSheet
//
////////////////////////////////////////////////////////////////////////////////
//
//   Version Id       : $Id$
//   Author           : karsten
//   Last Modified By : $Author$
//   Last Modified On : $Date$
//
////////////////////////////////////////////////////////////////////////////////

#ifndef _VIBRATION_SENSOR_DVCON14_SENSOR_VIBRATION_SENSOR_H_
#include "vibration_sensor.h"
#define FHG_INCLUDE_IMPLEMENTATION
#endif

namespace vibration_sensor_namespace
{

//-------------------------------------------------------------------//
// states                                                            //
//-------------------------------------------------------------------//
struct vibration_sensor::states
{
	bool start_up;     // Flag to mark first execution of processing().
	double x_in_last;  // Last displacement read in previous processing() execution.
	double x_dot;      // 1st time derivative of displacement, a.k.a. velocity.

    states()
    {
    	start_up=true;
    	x_in_last=0.0;
    	x_dot=0.0;
    }

};
//-------------------------------------------------------------------//

#ifdef FHG_INCLUDE_IMPLEMENTATION


//-------------------------------------------------------------------//
vibration_sensor::states& vibration_sensor::create_states() { return *(new states); }
//-------------------------------------------------------------------//


//////////////////////////////////////////////
// method processing                        //
//////////////////////////////////////////////
void vibration_sensor::processing()
{
	  // Calculate velocity as 1st time derivative of displacement by
	  // evaluating Newton's difference quotient for the current and
	  // last sample.
	  if (!s.start_up)
	  {
	    s.x_dot = (x_in.read() - s.x_in_last) / x_in.get_timestep().to_seconds();
	  }
	  else
	  {
	    s.start_up = false;
	  }

	  s.x_in_last = x_in.read();

	  // Convert vibration velocity to output voltage via conversion factor k.
	  v_out.write(p.k * s.x_dot);

}



#endif //#ifdef FHG_INCLUDE_IMPLEMENTATION

}  //end namespace vibration_sensor_dvcon14_namespace

//clear temporary defines
#undef FHG_INCLUDE_IMPLEMENTATION

