/*
 * Copyright (C) 2014 Torsten Maehne, Universit Pierre et Marie Curie
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
//
// PROJECT NAME: vibration_sensor_dvcon14
//
// LIBRARY NAME: frontend
//
// MODULE NAME:  clk_gen
//
// DESCRIPTION OF MODULE:
//      /* clock generator with jitter */
//
// DESCRIPTION OF PORTS:
// clk of type bool
//      /* clock output */
//
// DESCRIPTION OF PARAMETER:
// period of type sc_time
//      /* clock period */
// init of type bool
//      /* clock output before first edge */
// start of type sc_time
//      /* time of first edge */
// jitter of type double
//      /* jitter in percent of period */
//
// this file was generated by 'sca_xml2h.xsl' StyleSheet
//
////////////////////////////////////////////////////////////////////////////////
//
//   Version Id       : $Id$
//   Author           : karsten
//   Last Modified By : $Author$
//   Last Modified On : $Date$
//
////////////////////////////////////////////////////////////////////////////////


#ifndef _VIBRATION_SENSOR_FRONTEND_CLK_GEN_H_
#define _VIBRATION_SENSOR_FRONTEND_CLK_GEN_H_

#include <systemc.h>


namespace vibration_sensor_namespace
{

SC_MODULE(clk_gen)
{
    // sc ports
    sc_core::sc_out<bool  > clk;

    // parameters
    struct params
    {
        sc_time  period;
        bool  init;
        sc_time  start;
        double  jitter;

        params()
        {
            period = sc_time(1.0,SC_US);
            init = false;
            start = SC_ZERO_TIME;
            jitter = 0.0;
        }
    } p;

    void clk_method();



    SC_HAS_PROCESS(clk_gen);

    // constructor
    clk_gen(sc_core::sc_module_name nm, params pa = params() ) : clk("clk"),
                                                       p(pa),
                                                       s(create_states())
    {

        SC_METHOD(clk_method);


    }

    // states
    struct states;
    states& s;
    states* operator -> () { return &s; }

    private:
        static states& create_states();

};



} //end namespace vibration_sensor_namespace
using namespace vibration_sensor_namespace;


#endif

#ifdef ACCESS_MODULE_STATE_DECLARATION
#ifndef _VIBRATION_SENSOR_FRONTEND_CLK_GEN_CPP_
#define _VIBRATION_SENSOR_FRONTEND_CLK_GEN_CPP_
#include "clk_gen.cpp"
#endif
#endif
