/*
 * Copyright (C) 2014 Torsten Maehne, Universit Pierre et Marie Curie
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
//
// PROJECT NAME: vibration_sensor_dvcon14
//
// LIBRARY NAME: frontend
//
// MODULE NAME:  adc_reg
//
// DESCRIPTION OF MODULE:
//      /* register for adc value */
//
// DESCRIPTION OF PORTS:
// inp of type sc_dt::sc_int<NBitsADC>
//      /* input from adc */
// outp of type sc_dt::sc_int<NBitsADC>
//      /* registered output value */
//
//
// this file was generated by 'sca_xml2h.xsl' StyleSheet
//
////////////////////////////////////////////////////////////////////////////////
//
//   Version Id       : $Id$
//   Author           : karsten
//   Last Modified By : $Author$
//   Last Modified On : $Date$
//
////////////////////////////////////////////////////////////////////////////////


#ifndef _VIBRATION_SENSOR_FRONTEND_ADC_REG_H_
#define _VIBRATION_SENSOR_FRONTEND_ADC_REG_H_

#include <systemc-ams.h>


// user specified includes
#include "global_constants.h"


namespace vibration_sensor_namespace
{

SCA_TDF_MODULE(adc_reg)
{
    // sca tdf ports
    sca_tdf::sca_in<sc_dt::sc_int<NBitsADC>  > inp;
    sca_tdf::sc_out<sc_dt::sc_int<NBitsADC>  > outp;

    // parameters
    struct params
    {

        params()
        {
        }
    } p;


    //methods
    void processing();


    // constructor
    adc_reg(sc_core::sc_module_name nm, params pa = params() ) : inp("inp"),
                                                       outp("outp"),
                                                       p(pa),
                                                       s(create_states())
    {
        accept_attribute_changes();



    }

    // states
    struct states;
    states& s;
    states* operator -> () { return &s; }

    private:
        static states& create_states();

};



} //end namespace vibration_sensor_namespace
using namespace vibration_sensor_namespace;


#endif

#ifdef ACCESS_MODULE_STATE_DECLARATION
#ifndef _VIBRATION_SENSOR_FRONTEND_ADC_REG_CPP_
#define _VIBRATION_SENSOR_FRONTEND_ADC_REG_CPP_
#include "adc_reg.cpp"
#endif
#endif
