// Copyright (c) 1991-2009 by Synopsys Inc.

//This test shows vmm_ovm channel adapter between vmm generator and ovm driver
`define VMM_ON_TOP

`include "ovm_vmm_pkg.sv"
 
`include "ovm_apb_rw.sv"
`include "vmm_apb_rw.sv"
`include "apb_rw_converters.sv"
`include "apb_scoreboard.sv"

`include "ovm_consumers.sv"

class env extends `VMM_ENV;

   vmm_apb_rw_atomic_gen        gen;
   ovm_consumer   #(ovm_apb_rw) drv;
   apb_channel2tlm              adapter;
   apb_scoreboard               compare;
   
   bit PASS  = 0;
   
  `ovm_build
  virtual function void build();
    super.build();
    gen     = new("VMM Gen",1);
    drv     = new("OVM Drv", ovm_top);
    adapter = new("Channel Adapter", ovm_top, gen.out_chan);
    compare = new("comparator",      ovm_top, gen.out_chan);
    ovm_build();
    drv.blocking_get_port.connect(adapter.get_peek_export);
    drv.analysis_port.connect(compare.ovm_in);
//    void'(ovm_top.get_config_int("num_trans",gen.stop_after_n_insts));
  endfunction

  virtual task start();
    super.start();
    gen.start_xactor();
  endtask

  virtual task wait_for_end();
    super.wait_for_end();
    gen.notify.wait_for(vmm_apb_rw_atomic_gen::DONE);
  endtask

  virtual task stop();
    super.stop();
    gen.stop_xactor();
    if(compare.m_matches == gen.stop_after_n_insts 
       && compare.m_mismatches == 0)
      PASS  = 1;
  endtask

  virtual task cleanup();
   super.cleanup();
   `vmm_note(log, ((PASS==1)?"TEST RESULT PASSED":"TEST RESULT FAILED"));
  endtask
endclass

program example_14_vmm_channel2ovm_port;
  env e = new;

  initial begin
    e.build();
    e.gen.stop_after_n_insts = 10;
    e.run();
  end

endprogram