/*****************************************************************************

  The following code is derived, directly or indirectly, from the SystemC
  source code Copyright (c) 1996-2005 by all Contributors.
  All Rights reserved.

  The contents of this file are subject to the restrictions and limitations
  set forth in the SystemC Open Source License Version 2.4 (the "License");
  You may not use this file except in compliance with such restrictions and
  limitations. You may obtain instructions on how to receive a copy of the
  License at http://www.systemc.org/. Software distributed by Contributors
  under the License is distributed on an "AS IS" basis, WITHOUT WARRANTY OF
  ANY KIND, either express or implied. See the License for the specific
  language governing rights and limitations under the License.

 *****************************************************************************/

/*****************************************************************************

  stage3.cpp -- 

  Original Author: Martin Janssen, Synopsys, Inc., 2002-02-15

 *****************************************************************************/

/*****************************************************************************

  MODIFICATION LOG - modifiers, enter your name, affiliation, date and
  changes you are making here.

      Name, Affiliation, Date:
  Description of Modification:

 *****************************************************************************/

/* Filename stage3.cc */
/* This is the implementation file for synchronous process `stage3' */

#include <math.h>
#include "stage3.h"
#include "f_stage3.h"

extern "C" double pow(double, double);

void stage3::entry()
{
  double a, b;
  double c;

  a = 20.0;
  b = 5.0;
  while (true) {
    c = pow(a, b);
    powr.write(c);
    wait();
    a = prod.read();
    b = quot.read();
  }
} // end of entry function


void f_stage3(const char *NAME,
	      sc_clock& CLK,
	      const sc_signal<double>& PROD,
	      const sc_signal<double>& QUOT,
	      sc_signal<double>& POWR)
{
  SC_NEW(stage3(NAME, CLK, PROD, QUOT, POWR));
}

