/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test for assignemt operators

#include <systemc-ams>
#include "test_utilities.h"

using namespace std;

SCA_TDF_MODULE( mod_a )
{
  sca_tdf::sca_out<double> out_d;

  void set_attributes()
  {
    this->set_timestep(1.0, sc_core::SC_MS);
  }

  void processing()
  {
    d_val = b_toggle ? 1.1 : 0.1;
    out_d.write(d_val);

    b_toggle = !b_toggle;
  }

  SCA_CTOR( mod_a )
  {
    d_val = 0.0;
    b_toggle = true;
  }

  double d_val;
  bool b_toggle;
};


//////////////////////////////////////////////////////////////////////////////

SCA_TDF_MODULE( mod_b )
{
  sca_tdf::sca_in<double> in_d;
  sca_tdf::sca_de::sca_out<double> out_de_d;

  void initialize()
  {
    out_de_d.initialize_de_signal(-1.0);
  }

  void processing()
  {
    out_de_d.write(in_d.read());
  }

  SCA_CTOR( mod_b )
  {
  }
};


//////////////////////////////////////////////////////////////////////////////

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  sca_tdf::sca_signal<double> s_tdf_sig_d;
  sc_core::sc_signal<double>  s_de_sig_d;

  mod_a a("a");
    a.out_d(s_tdf_sig_d);

  mod_b b("b");
    b.in_d(s_tdf_sig_d);
    b.out_de_d(s_de_sig_d);

  sca_util::sca_trace_file* atf = sca_util::sca_create_tabular_trace_file("test01");

  sca_util::sca_trace(atf, s_tdf_sig_d, "s_tdf_sig_d"); // TDF signal: works
  sca_util::sca_trace(atf, a.out_d,     "a.out_d");     // TDF outport: works
  sca_util::sca_trace(atf, b.in_d,      "b.in_d");      // TDF inport: works
  sca_util::sca_trace(atf, s_de_sig_d,  "s_de_sig_d");  // DE signal: works
  sca_util::sca_trace(atf, b.out_de_d,  "b.out_de_d");  // TDF->DE outport: error

  sc_core::sc_start(5.0, sc_core::SC_MS);

  sca_util::sca_close_tabular_trace_file(atf);

  test_util::check_results("test01", 4);

  TEST_LABEL_END;

  return 0;
}
