/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// throw error when sca_ac_analysis::sca_ac is called outside ac_processing()

#include <systemc-ams>
#include "test_utilities.h"

SCA_TDF_MODULE( mod_a )
{
  sca_tdf::sca_out<double> out;

  void set_attributes()
  {
    set_timestep(1.0, sc_core::SC_MS);
  }

  void processing() {}

  SCA_CTOR( mod_a ) : out("out") {}
};

SCA_TDF_MODULE( mod_b )
{
  sca_tdf::sca_in<double> in;

  void processing()
  {
    sca_ac_analysis::sca_ac(in); // not allowed here
  }

  SCA_CTOR( mod_b ) : in("in") {}
};

int sc_main( int argn, char*[] )
{
  // redirect SystemC reports in case no arguments are given
  // (this is normally the case while running the regression suite).
  if (argn == 1)
    sc_core::sc_report_handler::set_handler(test_util::report_handler);

  TEST_LABEL_START;

  sca_tdf::sca_signal<double> sig1;

  mod_a a("a");
    a(sig1);

  mod_b b("b");
    b(sig1);

  sc_core::sc_start(2.0, sc_core::SC_MS);

  sca_ac_analysis::sca_ac_start(10.0, 100.0, 11, sca_ac_analysis::SCA_LOG);

  TEST_LABEL_END_WITHOUT_ERROR;

  return 0;
}
