/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test of missing sc_module_name ctor parameter warning

#include <systemc-ams>
#include "test_utilities.h"

SCA_TDF_MODULE( mod_a )
{
  sca_tdf::sca_out<double> out;

  void set_attributes()
  {
    out.set_timestep(1, sc_core::SC_MS);
  }

  SCA_CTOR( mod_a ) : out("out")
  {}

};

SCA_TDF_MODULE( mod_b )
{
  sca_tdf::sca_in<double> in;

  // Note: the constructor should be declared as
  // mod_b( sc_core::sc_module_name nm_ ) : sca_tdf::sca_module( nm_ )
  // the constructor below accepts the name, but does not pass it to the
  // sc_module name_object and should report an error

  mod_b( const char* nm ) : sca_tdf::sca_module( nm ), in ("in")
  {}

};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  sca_tdf::sca_signal<double> sig;

  mod_a a( "a" );
  a.out(sig);

  mod_b b( "b" );
  b.in(sig);

  sc_core::sc_start(1.0, sc_core::SC_MS);

  TEST_LABEL_END;
  return 0;
}
