/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test member functions set_rate() and get_rate()
// of ports of class sca_tdf::sca_de::sca_out

#include <systemc-ams>
#include "test_utilities.h"

SCA_TDF_MODULE( mod_a )
{
  sca_tdf::sca_out<int> out;

  int val;

  void processing()
  {
    out.write(val);
    val += 2;
  }

  SCA_CTOR( mod_a ) : out("out"), val(10)
  {
  }
};

SCA_TDF_MODULE( mod_b )
{
  sca_tdf::sca_in<int> in;
  sca_tdf::sca_de::sca_out<int> out;

  int val;

  void set_attributes()
  {
    out.set_rate(rate);
    out.set_timestep(0.5, sc_core::SC_MS);
  }

  void initialize()
  {
    std::cout << "out.set_rate() set to: " << rate << std::endl;
    std::cout << "out.get_rate(): " << out.get_rate() << std::endl;
    std::cout << "out.get_timestep(): " << out.get_timestep() << std::endl;
  }

  void processing()
  {
    std::cout << "-------- B --------" << std::endl;

    val = in.read();
    std::cout << "in:  " << in.get_time() << "\t" << val << std::endl;

    for (int i = 0; i < rate;  i++)
    {
      out.write(val+i, i);
      std::cout << "out[" << i << "]: " << out.get_time(i) << "\t" << val+i << std::endl;
    }
  }

  SCA_CTOR( mod_b ) : in("in"), out("out"), rate(2)
  {
  }

private:
  int rate;
};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  sca_tdf::sca_signal<int> tdf_sig;
  sc_core::sc_signal<int> sc_sig;

  mod_a a("a");
    a.out(tdf_sig);

  mod_b b("b");
    b.in(tdf_sig);
    b.out(sc_sig);

  sca_util::sca_trace_file* atf = sca_util::sca_create_tabular_trace_file("test05");

  sca_util::sca_trace(atf, tdf_sig, "tdf_sig");
  sca_util::sca_trace(atf, sc_sig, "sc_sig");
  
  sc_core::sc_start(10.0, sc_core::SC_MS);

  sca_util::sca_close_tabular_trace_file(atf);

  test_util::check_results("test05", 2);
  
  TEST_LABEL_END;

  return 0;
}
