/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test member functions set_rate() and get_rate()
// of ports of class sca_tdf::sca_de::sca_in<bool>

#include <systemc-ams>
#include "test_utilities.h"

SC_MODULE( mod_a )
{
  sc_core::sc_out<bool> out;

  void gen_sig()
  {
    while (true)
    {
      out.write(true);

      wait(sc_core::sc_time(1, sc_core::SC_MS));
    }
  }

  SC_CTOR( mod_a ) : out("out")
  {
    SC_THREAD( gen_sig );
  }

};


SCA_TDF_MODULE( mod_b )
{
  sca_tdf::sca_de::sca_in<bool> in;
  sca_tdf::sca_out<bool> out;

  void set_attributes()
  {
    in.set_rate(rate);
  }

  void initialize()
  {
    std::cout << "in.set_rate() set to: " << rate << std::endl;
    std::cout << "in.get_rate(): " << in.get_rate() << std::endl;
    std::cout << "in.get_timestep(): " << in.get_timestep() << std::endl;
  }

  void processing()
  {
    std::cout << "------- B -------" << std::endl;

    for (int i = 0; i < rate;  i++)
    {
      val = in.read(i);  
      std::cout << "in:  " << in.get_time(i) << "\t" << val << std::endl;
    }

    out.write(val);
    std::cout << "out:  " << out.get_time() << "\t" << val << std::endl;
  }

  SCA_CTOR( mod_b ) : in("in"), out("out"), rate(2) {}

 private:
  int rate;
  bool val;
};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  sca_tdf::sca_signal<bool> tdf_sig;
  sc_core::sc_signal<bool> sc_sig1;

  mod_a a("a");
    a.out(sc_sig1);

  mod_b b("b");
    b.in(sc_sig1);
    b.out(tdf_sig);
    b.set_timestep(1.0, sc_core::SC_MS);

  sca_util::sca_trace_file* atf = sca_util::sca_create_tabular_trace_file("test06");

  sca_util::sca_trace(atf, sc_sig1, "sc_sig1");
  sca_util::sca_trace(atf, tdf_sig, "tdf_sig");
  
  sc_core::sc_start(2.0, sc_core::SC_MS);

  sca_util::sca_close_tabular_trace_file(atf);

  test_util::check_results("test06", 2);
  
  TEST_LABEL_END;

  return 0;
}
