/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/
// test scaled amplification of primitive sca_lsf::sca_tdf::sca_gain

#include <systemc-ams>
#include "test_utilities.h"

SCA_TDF_MODULE( src_ramp )
{
  sca_tdf::sca_out<double> out;

  void processing()
  {
    out.write(val);
    val += 1.0;
  }

  SCA_CTOR( src_ramp ) : out("out"), val(0.25)
  {}
  
private:
  double val;
};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  sca_lsf::sca_source src("src");
  sca_lsf::sca_tdf::sca_gain gain("gain");
  src_ramp ramp("ramp");
  
  sca_lsf::sca_signal lsf_sig1, lsf_sig2;
  sca_tdf::sca_signal<double> tdf_sig;
  
  src.y(lsf_sig1);
  src.offset = 2.0;

  ramp.out(tdf_sig);

  gain.inp(tdf_sig);
  gain.x(lsf_sig1);
  gain.y(lsf_sig2);
  gain.scale = 2;
  gain.set_timestep(1.0, sc_core::SC_MS);
  
  sca_util::sca_trace_file* atf = sca_util::sca_create_tabular_trace_file("test04");

  sca_util::sca_trace(atf, tdf_sig, "tdf_sig");
  sca_util::sca_trace(atf, lsf_sig1, "lsf_sig1");
  sca_util::sca_trace(atf, lsf_sig2, "lsf_sig2");

  sc_core::sc_start(5.0, sc_core::SC_MS);

  sca_util::sca_close_tabular_trace_file(atf);

  test_util::check_results("test04", 3);

  TEST_LABEL_END;

  return 0;
}
