/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

#include <systemc-ams>
#include "test_utilities.h"

int sc_main(int argc, char* argv[])
{
  TEST_LABEL_START;
    
  sca_lsf::sca_signal s1, s2;
  sca_util::sca_vector<double> num, den; // numerator and denominator coefficients

  num(0) = -1.0;  //               2
  num(2) = 1.0;   //              s  - 1
  den(0) = 4.0;   //  H(s)=  ----------------
  den(1) = 6.0;   //          3     2
  den(2) = 4.0;   //         s  + 4s  + 6s + 4
  den(3) = 1.0;

  sca_lsf::sca_source step("step");
    step.y(s1);
    step.offset = 1.0;
    step.delay = sca_core::sca_time(0.1, sc_core::SC_SEC);

  sca_lsf::sca_ltf_nd ltf_nd("ltf_nd", num, den );
    ltf_nd.x(s1);
    ltf_nd.y(s2);
    ltf_nd.set_timestep(0.1, sc_core::SC_SEC);
      
  sca_util::sca_trace_file* tf = sca_util::sca_create_tabular_trace_file("test02");
  sca_util::sca_trace(tf, s1, "s1");
  sca_util::sca_trace(tf, s2, "s2");

  sc_core::sc_start(7, sc_core::SC_SEC);
  
  sca_util::sca_close_tabular_trace_file(tf);
  
  test_util::check_results("test02", 2);

  TEST_LABEL_END;
  
  return 0;  
}
