/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test demultiplexing of primitive sca_lsf::sca_de::sca_demux

// In this case, we deliberately have the wait statement in the discrete-event
// step function at the same time grid as the time step for the LSF functions.
// This means that due to the definition in AMS LRM 4.2.3.2.4, the updated value
// shows one artificial time step delay.

#include <systemc-ams>
#include "test_utilities.h"

SC_MODULE(step)
{
  sc_core::sc_out<bool> out; // output port

  SC_CTOR(step) : out("out")
  {
    SC_THREAD( my_step );
  }

  void my_step()
  {
    while (true)
    {
      wait(sc_core::sc_time(2.0, sc_core::SC_SEC));
      out.write(true);
    }
  }
};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  sca_lsf::sca_source source("source");
  sca_lsf::sca_de::sca_demux demux("demux");
  step step("step");
  
  sca_lsf::sca_signal lsf_sig1, lsf_sig2, lsf_sig3;
  sc_core::sc_signal<bool> de_sig;

  source.y(lsf_sig1);
  source.offset = 2.2;

  step.out(de_sig);
  
  demux.x(lsf_sig1);
  demux.y1(lsf_sig2);
  demux.y2(lsf_sig3);
  demux.ctrl(de_sig);
  demux.set_timestep(1.0, sc_core::SC_SEC);

  sca_util::sca_trace_file* atf = sca_util::sca_create_tabular_trace_file("test05");

  sca_util::sca_trace(atf, lsf_sig1, "lsf_sig1");
  sca_util::sca_trace(atf, de_sig, "de_sig");
  sca_util::sca_trace(atf, lsf_sig2, "lsf_sig2");
  sca_util::sca_trace(atf, lsf_sig3, "lsf_sig3");

  sc_core::sc_start(5.0, sc_core::SC_SEC);

  sca_util::sca_close_tabular_trace_file(atf);

  test_util::check_results("test05", 4);

  TEST_LABEL_END;

  return 0;
}
