/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test weighted addition of primitive sca_lsf::sca_add

#include <systemc-ams>
#include "test_utilities.h"

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  sca_lsf::sca_source src1("src1");
  sca_lsf::sca_source src2("src2");
  sca_lsf::sca_add add("add");

  sca_lsf::sca_signal sig1, sig2, sig3;

  src1.y(sig1);
  src1.offset = 2.0;
  
  src2.y (sig2);
  src2.offset = 3.0;
  
  add.x1(sig1);
  add.x2(sig2);
  add.k1 = 2.0;
  add.k2 = 0.5;
  add.y(sig3);
  add.set_timestep(1.0, sc_core::SC_MS);
  
  sca_util::sca_trace_file* atf = sca_util::sca_create_tabular_trace_file("test03");

  sca_util::sca_trace(atf, sig1, "sig1");
  sca_util::sca_trace(atf, sig2, "sig2");
  sca_util::sca_trace(atf, sig3, "sig3");

  sc_core::sc_start(5.0, sc_core::SC_MS);

  sca_util::sca_close_tabular_trace_file(atf);

  test_util::check_results("test03", 3);

  TEST_LABEL_END;

  return 0;
}
