/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

//  set_src_sink_change_src.cpp
//    -- Test that TDF module set_timestep() in the context of change_attributes()
//       generates an error if module time step is set in another module of the
//       same cluster.

#include <systemc-ams>
#include "test_utilities.h"

SCA_TDF_MODULE(src)
{
  sca_tdf::sca_out<int> out;

  SCA_CTOR(src)
  : out("out"), period(10), i(0)
  {}

  void set_attributes()
  {
    this->set_timestep( 1.0, sc_core::SC_US );
    does_attribute_changes();
    accept_attribute_changes();
  }

  void processing()
  {
    out.write(++i);
  }

  void change_attributes()
  {
    if ( !(i % period) )
    {
      this->set_timestep( (i / period) + 1, sc_core::SC_US );
    }
  }

private:
  int period;
  int i;
};

SCA_TDF_MODULE(sink)
{
  sca_tdf::sca_in<int> in;

  SCA_CTOR(sink)
  : in("in")
  {}

  void set_attributes()
  {
    accept_attribute_changes();
    this->set_timestep(1.0, sc_core::SC_US);
  }

  void processing()
  {
    std::cout << this->name() << " @ " << this->get_time()
              << ": " << in.read() << std::endl;
  }
};

int sc_main(int argc, char* argv[])
{
  using namespace sc_core;

  TEST_LABEL_START;

  sca_tdf::sca_signal<int> sig1("sig1");

  src src1("src1");
  src1.out(sig1);

  sink sink1("sink1");
  sink1.in(sig1);

  sc_time tstop(100.0, SC_US);

  try
  { 
    sc_start(tstop);
  }
  catch (const std::exception& e)
  {
    std::cerr << e.what() << std::endl;
  }

  TEST_LABEL_END;
  sc_stop();

  return sc_report_handler::get_count(SC_ERROR);
}

// vim: expandtab : tabstop=2 : softtabstop=2 : shiftwidth=2
