/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test member functions set_rate() and get_rate()
// of ports of class sca_tdf::sca_in and sca_tdf::sca_out<T, sca_tdf::SCA_NO_CUT>

#include <systemc-ams>
#include "test_utilities.h"

SCA_TDF_MODULE( mod_a )
{
  sca_tdf::sca_out<double, sca_tdf::SCA_NO_CUT> out;

  void set_attributes()
  {
    out.set_rate(rate);
    out.set_timestep(1, sc_core::SC_MS);
  }

  void initialize()
  {
    std::cout << "out.kind() : " << out.kind() << std::endl;
    std::cout << "out.name() : " << out.name() << std::endl;
    std::cout << "out.get_rate() : " << out.get_rate() << std::endl;
  }

  void processing()
  {
    for (int i = 0; i < rate;  i++)
    {
      out.write(val, i);
      std::cout << "out: " << out.get_time(i) << "\t" << val << std::endl;
      val++;
    }
    std::cout << std::endl;
  }

  SCA_CTOR( mod_a ) : out("out"), rate(3), val(10.0)
  {
  }

 private:
  int rate;
  double val;
};

SCA_TDF_MODULE( mod_b )
{
  sca_tdf::sca_in<double> in;

  void set_attributes()
  {
    in.set_rate(rate);
  }

  void processing()
  {
  }

  SCA_CTOR( mod_b ) : in("in"), rate(2)
  {
  }

 private:
  int rate;
};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  sca_tdf::sca_signal<double> sig;

  mod_a a("a");
    a.out(sig);

  mod_b b("b");
    b.in(sig);

  sc_core::sc_start(10, sc_core::SC_MS);

  TEST_LABEL_END;

  return 0;
}
