/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test for assignment operators for sca_tdf::sca_out<T, sca_tdf::SCA_CT_CUT>

#include <systemc-ams>
#include "test_utilities.h"

SCA_TDF_MODULE( mod_a )
{
  sca_tdf::sca_out<bool, sca_tdf::SCA_CT_CUT> out_b;
  sca_tdf::sca_out<sc_dt::sc_logic, sca_tdf::SCA_CT_CUT> out_l;
  sca_tdf::sca_out<int, sca_tdf::SCA_CT_CUT> out_i;

  sca_tdf::sca_out<bool, sca_tdf::SCA_CT_CUT> out_de_b;
  sca_tdf::sca_out<sc_dt::sc_logic, sca_tdf::SCA_CT_CUT> out_de_l;
  sca_tdf::sca_out<int, sca_tdf::SCA_CT_CUT> out_de_i;

  sca_tdf::sca_out<bool, sca_tdf::SCA_CT_CUT> out_c_b;
  sca_tdf::sca_out<sc_dt::sc_logic, sca_tdf::SCA_CT_CUT> out_c_l;
  sca_tdf::sca_out<int, sca_tdf::SCA_CT_CUT> out_c_i;

  sca_tdf::sca_de::sca_in<bool> in_de_b;
  sca_tdf::sca_de::sca_in<sc_dt::sc_logic> in_de_l;
  sca_tdf::sca_de::sca_in<int> in_de_i;

  sca_tdf::sca_in<bool> in_b;
  sca_tdf::sca_in<sc_dt::sc_logic> in_l;
  sca_tdf::sca_in<int> in_i;

  int val;

  void set_attributes()
  {
    out_b.set_delay(1);
    out_l.set_delay(1);
    out_i.set_delay(1);

    out_de_b.set_delay(1);
    out_de_l.set_delay(1);
    out_de_i.set_delay(1);

    out_c_b.set_delay(1);
    out_c_l.set_delay(1);
    out_c_i.set_delay(1);
  }

  void initialize()
  {
    out_b.initialize(false);
    out_l.initialize(sc_dt::SC_LOGIC_X);
    out_i.initialize(0);

    out_de_b.initialize(false);
    out_de_l.initialize(sc_dt::SC_LOGIC_X);
    out_de_i.initialize(0);

    out_c_b.initialize(false);
    out_c_l.initialize(sc_dt::SC_LOGIC_X);
    out_c_i.initialize(0);
  }

  void processing()
  {
    out_b = in_b;
    out_l = in_l;
    out_i = in_i;

    out_de_b = in_de_b;
    out_de_l = in_de_l;
    out_de_i = in_de_i;

    out_c_b = b_val;
    out_c_l = l_val;
    out_c_i = i_val;

    b_val = !b_val;

    if (l_val == sc_dt::SC_LOGIC_X) l_val = sc_dt::SC_LOGIC_Z;
    else if (l_val == sc_dt::SC_LOGIC_Z) l_val = sc_dt::SC_LOGIC_0;
    else if (l_val == sc_dt::SC_LOGIC_0) l_val = sc_dt::SC_LOGIC_1;
    else if (l_val == sc_dt::SC_LOGIC_1) l_val = sc_dt::SC_LOGIC_X;

    i_val++;
  }

  SCA_CTOR( mod_a )
  : out_b("out_b"), out_l("out_l"), out_i("out_i"),
    out_de_b("out_de_b"), out_de_l("out_de_l"), out_de_i("out_de_i"),
    out_c_b("out_c_b"), out_c_l("out_c_l"), out_c_i("out_c_i"),
    in_de_b("in_de_b"), in_de_l("in_de_l"), in_de_i("in_de_i"),
    in_b("in_b"), in_l("in_l"), in_i("in_i"),
    b_val(false), l_val(sc_dt::SC_LOGIC_Z), i_val(0)
  {
  }

  bool b_val;
  sc_dt::sc_logic l_val;
  int i_val;
};

//////////////////////////////////////////////////////////////////////////////

SCA_TDF_MODULE( mod_b )
{
  sca_tdf::sca_out<bool>            out_b;
  sca_tdf::sca_out<sc_dt::sc_logic> out_l;
  sca_tdf::sca_out<int>             out_i;

  sca_tdf::sca_de::sca_out<bool>            out_de_b;
  sca_tdf::sca_de::sca_out<sc_dt::sc_logic> out_de_l;
  sca_tdf::sca_de::sca_out<int>             out_de_i;

  void set_attributes()
  {
    this->set_timestep(1.0, sc_core::SC_MS);
  }

  void processing()
  {
    out_b = b_val;
    out_l = l_val;
    out_i = i_val;

    b_val = !b_val;

    if (l_val == sc_dt::SC_LOGIC_X) l_val = sc_dt::SC_LOGIC_Z;
    else if (l_val == sc_dt::SC_LOGIC_Z) l_val = sc_dt::SC_LOGIC_0;
    else if (l_val == sc_dt::SC_LOGIC_0) l_val = sc_dt::SC_LOGIC_1;
    else if (l_val == sc_dt::SC_LOGIC_1) l_val = sc_dt::SC_LOGIC_X;

    i_val++;

    out_de_b = b_val;
    out_de_l = l_val;
    out_de_i = i_val;
  }

  SCA_CTOR( mod_b )
  : out_b("out_b"), out_l("out_l"), out_i("out_i"),
    out_de_b("out_de_b"), out_de_l("out_de_l"), out_de_i("out_de_i"),
    b_val(false), l_val(sc_dt::SC_LOGIC_X), i_val(0)
  {
  }

private:

  bool b_val;
  sc_dt::sc_logic l_val;
  int i_val;
};

// module for time step assignment for de-clustered signals
SCA_TDF_MODULE( mod_c )
{
  sca_tdf::sca_in<bool> out_b;
  sca_tdf::sca_in<sc_dt::sc_logic> out_l;
  sca_tdf::sca_in<int> out_i;

  sca_tdf::sca_in<bool> out_de_b;
  sca_tdf::sca_in<sc_dt::sc_logic> out_de_l;
  sca_tdf::sca_in<int> out_de_i;

  sca_tdf::sca_in<bool> out_c_b;
  sca_tdf::sca_in<sc_dt::sc_logic> out_c_l;
  sca_tdf::sca_in<int> out_c_i;

  void set_attributes()
  {
    this->set_timestep(1.0, sc_core::SC_MS);
  }

  void processing()
  {
  }

  SCA_CTOR(mod_c)
  : out_b("out_b"), out_l("out_l"), out_i("out_i"),
    out_de_b("out_de_b"), out_de_l("out_de_l"), out_de_i("out_de_i"),
    out_c_b("out_c_b"), out_c_l("out_c_l"), out_c_i("out_c_i")
  {
  }
};


//////////////////////////////////////////////////////////////////////////////

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  sca_tdf::sca_signal<bool>            so_tdf_sig_b;
  sca_tdf::sca_signal<sc_dt::sc_logic> so_tdf_sig_l;
  sca_tdf::sca_signal<int>             so_tdf_sig_i;

  sc_core::sc_signal<bool>            so_de_sig_b;
  sc_core::sc_signal<sc_dt::sc_logic> so_de_sig_l;
  sc_core::sc_signal<int>             so_de_sig_i;

  sca_tdf::sca_signal<bool>             si_tdf_sig_b;
  sca_tdf::sca_signal<sc_dt::sc_logic>  si_tdf_sig_l;
  sca_tdf::sca_signal<int>              si_tdf_sig_i;

  sca_tdf::sca_signal<bool>            si_de_sig_b;
  sca_tdf::sca_signal<sc_dt::sc_logic> si_de_sig_l;
  sca_tdf::sca_signal<int>             si_de_sig_i;

  sca_tdf::sca_signal<bool>            si_c_sig_b;
  sca_tdf::sca_signal<sc_dt::sc_logic> si_c_sig_l;
  sca_tdf::sca_signal<int>             si_c_sig_i;


  mod_b b("b");
  b.out_b(so_tdf_sig_b);
  b.out_l(so_tdf_sig_l);
  b.out_i(so_tdf_sig_i);

  b.out_de_b(so_de_sig_b);
  b.out_de_l(so_de_sig_l);
  b.out_de_i(so_de_sig_i);

  mod_a a("a");
  a.in_b(so_tdf_sig_b);
  a.in_l(so_tdf_sig_l);
  a.in_i(so_tdf_sig_i);

  a.in_de_b(so_de_sig_b);
  a.in_de_l(so_de_sig_l);
  a.in_de_i(so_de_sig_i);

  a.out_b(si_tdf_sig_b);
  a.out_l(si_tdf_sig_l);
  a.out_i(si_tdf_sig_i);

  a.out_de_b(si_de_sig_b);
  a.out_de_l(si_de_sig_l);
  a.out_de_i(si_de_sig_i);

  a.out_c_b(si_c_sig_b);
  a.out_c_l(si_c_sig_l);
  a.out_c_i(si_c_sig_i);

  mod_c c("c");
  c.out_b(si_tdf_sig_b);
  c.out_l(si_tdf_sig_l);
  c.out_i(si_tdf_sig_i);

  c.out_de_b(si_de_sig_b);
  c.out_de_l(si_de_sig_l);
  c.out_de_i(si_de_sig_i);

  c.out_c_b(si_c_sig_b);
  c.out_c_l(si_c_sig_l);
  c.out_c_i(si_c_sig_i);

  sca_util::sca_trace_file* atf = sca_util::sca_create_tabular_trace_file("test04");

  sca_util::sca_trace(atf, so_tdf_sig_b, "so_tdf_sig_b");
  sca_util::sca_trace(atf, so_tdf_sig_l, "so_tdf_sig_l");
  sca_util::sca_trace(atf, so_tdf_sig_i, "so_tdf_sig_i");

  sca_util::sca_trace(atf, so_de_sig_b, "so_de_sig_b");
  sca_util::sca_trace(atf, so_de_sig_l, "so_de_sig_l");
  sca_util::sca_trace(atf, so_de_sig_i, "so_de_sig_i");

  sca_util::sca_trace(atf, si_tdf_sig_b, "si_tdf_sig_b");
  sca_util::sca_trace(atf, si_tdf_sig_l, "si_tdf_sig_l");
  sca_util::sca_trace(atf, si_tdf_sig_i, "si_tdf_sig_i");

  sca_util::sca_trace(atf, si_de_sig_b, "si_de_sig_b");
  sca_util::sca_trace(atf, si_de_sig_l, "si_de_sig_l");
  sca_util::sca_trace(atf, si_de_sig_i, "si_de_sig_i");

  sca_util::sca_trace(atf, si_c_sig_b, "si_c_sig_b");
  sca_util::sca_trace(atf, si_c_sig_l, "si_c_sig_l");
  sca_util::sca_trace(atf, si_c_sig_i, "si_c_sig_i");

  sc_core::sc_start(10.0, sc_core::SC_MS);

  sca_util::sca_close_tabular_trace_file(atf);

  test_util::check_results("test04", 16);

  TEST_LABEL_END;

  return 0;
}
