/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test sca_ltf_zp for SystemC-AMS 2.0 dtdf -
// correct integration with variable timesteps

#include <systemc-ams>
#include "test_utilities.h"

SCA_TDF_MODULE( mod_a )
{
  sca_tdf::sca_ltf_zp ltf1, ltf2, ltf3, ltf4;
  sca_util::sca_vector<sca_util::sca_complex> zeros, poles;
  sca_util::sca_vector<double> s1, s4;

  void set_attributes()
  {
    set_timestep(1.0, sc_core::SC_MS);
    does_attribute_changes();
  }

  void initialize()
  {
    poles(0) = 0.0;  // 1.0/s
  }

  void reinitialize()
  {
  }

  void processing()
  {
    double out1 = ltf1(zeros, poles, s1, 1.0);
    double out2 = ltf2(zeros, poles, 1.0);

    if (std::fabs(get_time().to_seconds() - out1) > out1 / 1e12)
    {
      std::ostringstream str;
      str << "Unexpected result for out1: " << out1 << " at: "
          << get_time().to_seconds() << " sec";
      SC_REPORT_ERROR("Check", str.str().c_str());
    }

    if (std::fabs(get_time().to_seconds() - out2) > out2 / 1e12)
    {
      std::ostringstream str;
      str << "Unexpected result for out2: " << out2 << " at: "
          << get_time().to_seconds() << " sec";
      SC_REPORT_ERROR("Check", str.str().c_str());
    }

    ///////////////////////////////////////////////////////

    double out3 = ltf3(zeros, poles, 1.0, 1.0, get_timestep() / 3);

    if (get_time() > sc_core::SC_ZERO_TIME)
    {
      double exv = (get_time() - get_timestep() + get_timestep() / 3).to_seconds();

      if (std::fabs(exv - out3) > out3 / 1e12)
      {
        std::ostringstream str;
        str << "Unexpected result for out3 (partial timestep): " << out3 << " at: "
            << exv << " sec";
        SC_REPORT_ERROR("Check", str.str().c_str());
      }
    }
    else
    {
      if (std::fabs(out3) > 1e-32)
      {
        std::ostringstream str;
        str << "Unexpected result for out3 (dc-value): " << out3 << " at: "
            << 0 << " sec";
        SC_REPORT_ERROR("Check", str.str().c_str());

      }
    }

    out3 = ltf3(zeros, poles, 1.0);

    if (std::fabs(get_time().to_seconds() - out3) > out3 / 1e12)
    {
      std::ostringstream str;
      str << "Unexpected result for out3: " << out3 << " at: "
          << get_time().to_seconds() << " sec";
      SC_REPORT_ERROR("Check", str.str().c_str());
    }

    ///////////////////////////////////////////////////////

    double out4 = ltf4(zeros, poles, s4, 1.0, 1.0, get_timestep() / 4);

    if (get_time() > sc_core::SC_ZERO_TIME)
    {
      double exv = (get_time() - get_timestep() + get_timestep() / 4).to_seconds();

      if (std::fabs(exv - out4) > out4 / 1e12)
      {
        std::ostringstream str;
        str << "Unexpected result for out4 (partial timestep): " << out4 << " at: "
            << exv << " sec";
        SC_REPORT_ERROR("Check", str.str().c_str());
      }
    }
    else
    {
      if (std::fabs(out4) > 1e-32)
      {
        std::ostringstream str;
        str << "Unexpected result for out4 (dc-value): " << out4 << " at: "
            << 0 << " sec";
        SC_REPORT_ERROR("Check", str.str().c_str());

      }
    }

    out4 = ltf4(zeros, poles, s4, 1.0, 1.0, get_timestep() / 3);

    if (get_time() > sc_core::SC_ZERO_TIME)
    {
      double exv = (get_time()-get_timestep() +
          get_timestep() / 4 +
          get_timestep() / 3).to_seconds();

      if (std::fabs(exv - out4) > out4 / 1e12)
      {
        std::ostringstream str;
        str << "Unexpected result for out4 (partial timestep): " << out4 << " at: "
            << exv << " sec";
        SC_REPORT_ERROR("Check", str.str().c_str());
      }
    }
    else
    {
      if (std::fabs(out4) > 1e-32)
      {
        std::ostringstream str;
        str << "Unexpected result for out4 (dc-value): " << out4 << " at: "
            << 0 << " sec";
        SC_REPORT_ERROR("Check", str.str().c_str());

      }
    }

    out4 = ltf4(zeros, poles, s4, 1.0);

    if (std::fabs(get_time().to_seconds() - out4) > out4 / 1e12)
    {
      std::ostringstream str;
      str << "Unexpected result for out4: " << out4 << " at: "
          << get_time().to_seconds() << " sec";
      SC_REPORT_ERROR("Check", str.str().c_str());
    }
  }

  void change_attributes()
  {
    switch(cnt)
    {
      case 0:
      case 1:
        break;
      case 2:
        request_next_activation(0.5, sc_core::SC_MS);
        break;
      case 3:
        break;
      case 4:
        request_next_activation(0.5, sc_core::SC_MS);
        break;
      case 5:
        request_next_activation(0.6, sc_core::SC_MS);
        break;
      case 6:
        break;
      case 7:
        set_timestep(0.3, sc_core::SC_MS);
        break;
      case 8:
        break;
      case 9:
        set_timestep(1.3, sc_core::SC_MS);
        break;
      case 10:
        break;
      case 11:
        request_next_activation(1.5, sc_core::SC_MS);
        break;
      case 12:
        break;
      case 13:
        set_max_timestep(0.7, sc_core::SC_MS);
        break;
      case 14:
        break;
      case 15:
        request_next_activation(0.5, sc_core::SC_MS);
        break;
      case 16:
        break;
      case 17:
        request_next_activation(0.5, sc_core::SC_MS);
        break;
      case 18:
        request_next_activation(0.8, sc_core::SC_MS);
        set_max_timestep(1.0, sc_core::SC_MS);
        break;
      default:
        sc_core::sc_stop();
        break;
    }
    cnt++;
  }

  SCA_CTOR( mod_a ) : cnt(0),
    ltf1("ltf1"), ltf2("ltf2"), ltf3("ltf3"), ltf4("ltf4")
  {}

 private:
  long cnt;
};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  mod_a a("a");

  sc_core::sc_start();

  TEST_LABEL_END;

  return 0;
}
