/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test of interpolation of decoupling port of type
// sca_tdf::sca_out<T, sca_tdf::SCA_DT_CUT>

#include <systemc-ams>
#include "test_utilities.h"

SCA_TDF_MODULE( mod_a )
{
  sca_tdf::sca_out<double> out;

  void set_attributes()
  {
    set_timestep(10.0, sc_core::SC_MS);
  }

  void processing()
  {
    out.write(val);
    val++;
  }

  SCA_CTOR( mod_a ): out("out"), val(1.0) {}

 private:
  double val;
};

SCA_TDF_MODULE( mod_b )
{
  sca_tdf::sca_in<double>  in;
  sca_tdf::sca_out<double> out;

  void set_attributes()
  {
  }

  void processing()
  {
    double val = in.read();
    out.write(val);
  }

  SCA_CTOR( mod_b ): in("in"), out("out") {}
};

SC_MODULE(hier_b)
{
  sca_tdf::sca_in<double> in;
  sca_tdf::sca_out<double, sca_tdf::SCA_DT_CUT> out;

  mod_b* i_mod_b;

  SC_CTOR(hier_b)
  {
    i_mod_b = new mod_b("i_mod_b");
    i_mod_b->in(in);
    i_mod_b->out(out);

    out.set_initial_value(-1);
  }

  ~hier_b()
  {
    delete i_mod_b;
  }
};

SC_MODULE(hier_hier_b)
{
  sca_tdf::sca_in<double> in;
  sca_tdf::sca_out<double> out;

  hier_b* i_mod_b;

  SC_CTOR(hier_hier_b)
  {
    i_mod_b = new hier_b("i_mod_b");
    i_mod_b->in(in);
    i_mod_b->out(out);
  }

  ~hier_hier_b()
  {
    delete i_mod_b;
  }
};

SCA_TDF_MODULE( mod_c )
{
  sca_tdf::sca_in<double> in;
  sca_tdf::sca_out<double> out;

  void set_attributes()
  {
    set_timestep(8.0, sc_core::SC_MS);
  }

  void processing()
  {
    double val = in.read();
    out.write(val);
  }

  SCA_CTOR( mod_c ): in("in"), out("out") {}
};

SCA_TDF_MODULE( mod_d )
{
  sca_tdf::sca_in<double> in;

  void processing()
  {
    double val = in.read();
  }

  SCA_CTOR( mod_d ): in("in") {}
};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  mod_a a("a");
  hier_hier_b i_hier_hier_b("i_hier_hier_b");
  mod_c c("c");
  mod_d d("d");

  sca_tdf::sca_signal<double> sig_ab, sig_bc, sig_cd;

  a.out(sig_ab);
  i_hier_hier_b.in(sig_ab);
  i_hier_hier_b.out(sig_bc);
  c.in(sig_bc);
  c.out(sig_cd);
  d.in(sig_cd);

  sca_util::sca_trace_file* tf = sca_util::sca_create_tabular_trace_file("test02");
    sca_util::sca_trace(tf, sig_ab, "sig_ab");
    sca_util::sca_trace(tf, sig_bc, "sig_bc");
    sca_util::sca_trace(tf, sig_cd, "sig_cd");

  sc_core::sc_start(30, sc_core::SC_MS);

  sca_util::sca_close_tabular_trace_file(tf);

  test_util::check_results("test02", 3);

  TEST_LABEL_END;

  return 0;
}
