/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// my_de2tdf from user's guide

#include <systemc-ams>
#include "test_utilities.h"

test_util::sorted_stream sstr;

#define DISPA(mod, val) \
  sstr.set_time(this->get_time(), 0); \
  sstr << mod.name() << ": " << val << " at " << mod.get_time() << std::endl; \
  sstr.flush_stamp()

#define DISP(mod, val) \
  sstr.set_time(sc_core::sc_time_stamp(), 1); \
  sstr << mod.name() << ": " << val << " at " << sc_core::sc_time_stamp() << std::endl; \
  sstr.flush_stamp()

SCA_TDF_MODULE(my_de2tdf)
{
  sca_tdf::sca_de::sca_in<double> inp; // input converter port
  sca_tdf::sca_out<double> out;        // output port

  SCA_CTOR(my_de2tdf) : inp("inp"), out("out") {}

  void set_attributes()
  {
    out.set_timestep(1.0, sc_core::SC_MS);
  }

  void processing()
  {
    double val = inp.read();
    out.write( val );
    DISPA(out, val);
  }
};

SC_MODULE(my_de_source)
{
  sc_core::sc_out<double> out;

  SC_CTOR(my_de_source) : out("out")
  {
    SC_THREAD(processing);
  }

  void processing()
  {
    while (true)
    {
      double val;

      // hard-coded discrete-event waveform
      val = 2.1;
      out.write( val );
      DISP(out, val);
      wait(3.2, sc_core::SC_MS);
      val = 3.1;
      out.write( val );
      DISP(out, val);
      wait(0.6, sc_core::SC_MS);
      val = 4.1;
      out.write( val );
      DISP(out, val);
      wait(2.4, sc_core::SC_MS);
      val = 1.1;
      out.write( val );
      DISP(out, val);
      wait(2.2, sc_core::SC_MS);
      val = 4.1;
      out.write( val );
      DISP(out, val);
      wait(2.4, sc_core::SC_MS);
    }
  }
};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  sc_core::sc_signal<double> de_sig;
  sca_tdf::sca_signal<double> tdf_sig;

  my_de_source src("src");
    src.out(de_sig);

  my_de2tdf de2tdf("de2tdf");
    de2tdf.inp(de_sig);
    de2tdf.out(tdf_sig);

  sca_util::sca_trace_file* atf = sca_util::sca_create_tabular_trace_file("my_de2tdf");

  sca_util::sca_trace(atf, de_sig, "de_sig");
  sca_util::sca_trace(atf, tdf_sig, "tdf_sig");

  sc_core::sc_start(20, sc_core::SC_MS);

  sca_util::sca_close_tabular_trace_file(atf);

  sstr.print();

  TEST_LABEL_END;

  return 0;
}
