/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// user's guide example of comb_filter
 
#include <systemc-ams>
#include "test_utilities.h"

SCA_TDF_MODULE(comb_filter)
{
  sca_tdf::sca_in<bool> in;
  sca_tdf::sca_out<sc_dt::sc_int<28> > out;

  comb_filter( sc_core::sc_module_name, int k_ = 64, int n_ = 3 ) 
  : in("in"), out("out"), k(k_), n(n_) {} 

  void set_attributes()
  {
    in.set_rate(k);
    out.set_rate(1);
  }
  
  void ac_processing() // frequency-domain implementation
  {
    // complex transfer function
    sca_util::sca_complex h = pow( ( 1.0 - sca_ac_analysis::sca_ac_z(-k) ) /
                                   ( 1.0 - sca_ac_analysis::sca_ac_z(-1) ), n );

    sca_ac_analysis::sca_ac(out) = h * sca_ac_analysis::sca_ac(in) ;
  }

  void processing()    // time-domain implementation
  {
    int x, y(0), i;
    for ( i = 0; i < k; i++) {
      x = in.read(i);
      //...
    }
    out.write(y);
  }
 
 private:
  int k; // decimation factor
  int n; // order of filter 
};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  comb_filter cf("cf"); 

  TEST_LABEL_END;

  return 0;
}
