/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// user's guide example to trace to a stream
 
#include <systemc-ams>
#include "test_utilities.h"

SCA_TDF_MODULE(generator)
{
  sca_tdf::sca_out<double> out;
  
  unsigned long i;
  
  SCA_CTOR(generator) : out("out"), i(0) {}
  
  void set_attributes()
  {
    set_timestep(1.0, sc_core::SC_MS);
  }
  
  void processing()
  {
    out.write(i);
    std::cout << "time: " << get_time() << " value: " << i << std::flush << std::endl;
    i++;
  }
};  
    
int sc_main(int argc, char* argv[])
{
  sc_core::sc_set_time_resolution(1.0, sc_core::SC_FS);

  TEST_LABEL_START; // added for regression

  sca_tdf::sca_signal<double> sig1;
  
  generator gen("gen");
    gen.out(sig1);

  std::ostringstream str;

  // trace in tabular format to the stream
  sca_util::sca_trace_file* atfs = sca_util::sca_create_tabular_trace_file(str);

  //...
  sca_util::sca_trace(atfs, sig1, "sig1");

  sc_core::sc_start(5.0, sc_core::SC_MS);

  // add comment to trace file
  sca_util::sca_write_comment( atfs, "user-defined comments" );
  sca_util::sca_write_comment( atfs, sc_core::sc_time_stamp().to_string() );
  std::cout << "hello" << std::endl;

  sc_core::sc_start(5.0, sc_core::SC_MS);

  sca_util::sca_close_tabular_trace_file(atfs);

  std::cout << std::endl << "Data written to stream: " << std::endl;

  std::cout << str.str() << std::endl;

  TEST_LABEL_END; // added for regression

  return 0;
}
