/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// user's guide example of a testbench in sc_main 
 
#include <systemc-ams>

// part for regression
#include "test_utilities.h"
// end part for regression

#include "my_source.h"
#include "my_control.h"
#include "my_dut.h"
#include "my_sink.h"

int sc_main(int argc, char* argv[])
{
  sc_core::sc_set_time_resolution(1.0, sc_core::SC_FS);

  TEST_LABEL_START; // added for regression

  sca_tdf::sca_signal<double> sig1, sig2;
  sc_core::sc_signal<bool> sc_sig;
   
  my_source i_my_source("i_my_source");
    i_my_source.out(sig1);

  my_control i_my_ctrl("i_my_ctrl");
    i_my_ctrl.out(sc_sig);

  my_dut i_my_dut("i_my_dut");
    i_my_dut.in(sig1);
    i_my_dut.ctrl(sc_sig);
    i_my_dut.out(sig2);

  my_sink i_my_sink("i_my_sink");
    i_my_sink.in(sig2);

  sc_core::sc_trace_file* tf = sc_core::sc_create_vcd_trace_file("my_sc_trace");
  sc_core::sc_trace(tf, sc_sig, "sc_sig"); 

  sca_util::sca_trace_file* atf1 = sca_util::sca_create_vcd_trace_file("ams_vcd_trace.vcd");
  sca_util::sca_trace(atf1, sig1, "sig1"); 

  sca_util::sca_trace_file* atf2 = sca_util::sca_create_tabular_trace_file("ams_trace.dat");
  sca_util::sca_trace(atf2, sig2, "sig2");

  sc_core::sc_start(2, sc_core::SC_MS);

  //sc_starts stops before the first delta - so the current time and trace
  //has not been executed - after a delta this had happen
  //otherwise the point will be placed in the new trace file
  sc_core::sc_start(sc_core::SC_ZERO_TIME);

  atf2->reopen("ams_trace.dat");
  sc_core::sc_start(2, sc_core::SC_MS);

  atf2->disable();
  sc_core::sc_start(2, sc_core::SC_MS);

  atf2->enable();
  atf2->set_mode( sca_util::sca_decimation(2) );
  sc_core::sc_start(2, sc_core::SC_MS);

  //sc_starts stops before the first delta - so the current time and trace
  //has not been executed - after a delta this had happen
  //otherwise the point will be placed in the new trace file
  sc_core::sc_start(sc_core::SC_ZERO_TIME);

  atf2->reopen("ams_trace3.dat");

  sca_core::sca_time tstep(1, sc_core::SC_MS);
  atf2->set_mode( sca_util::sca_sampling( tstep, sc_core::SC_ZERO_TIME ) );   
  sc_core::sc_start(10, sc_core::SC_MS);

  sc_core::sc_close_vcd_trace_file(tf);
  sca_util::sca_close_vcd_trace_file(atf1);
  sca_util::sca_close_tabular_trace_file(atf2);

  // part below for regression -- not part of users guide
  test_util::check_results("ams_trace", 1, "testbench");
  test_util::check_results("ams_trace3", 1, "testbench");

  TEST_LABEL_END;

  return 0;
}
