/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// user's guide example of sc_main for time domain simulation
 
#include <systemc-ams>
#include "test_utilities.h"
#include "my_source.h"
#include "my_control.h"
#include "my_dut.h"
#include "my_sink.h"

int sc_main(int argc, char* argv[])
{
  sc_core::sc_set_time_resolution(1.0, sc_core::SC_FS);

  TEST_LABEL_START;

  sca_tdf::sca_signal<double> sig1, sig2;
  sc_core::sc_signal<bool> sc_sig;

  my_source i_my_source("i_my_source");
    i_my_source.out(sig1);

  my_control i_my_ctrl("i_my_ctrl");
    i_my_ctrl.out(sc_sig);

  my_dut i_my_dut("i_my_dut");
    i_my_dut.in(sig1);
    i_my_dut.ctrl(sc_sig);
    i_my_dut.out(sig2);

  my_sink i_my_sink("i_my_sink");
    i_my_sink.in(sig2);

  sc_core::sc_start(10, sc_core::SC_MS);

  TEST_LABEL_END;

  return 0;
}
