/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// user's guide pwm_driver

#include <systemc-ams>
#include "test_utilities.h"

SC_MODULE(pwm_driver)
{
  sc_core::sc_in<bool> in;
  sca_eln::sca_terminal  out;

  sca_eln::sca_vsource vcc;  // voltage source
  sca_eln::sca_de::sca_rswitch highside, lowside;  // two switches

  pwm_driver( sc_core::sc_module_name nm, double vcc_ = 5.0)
  : in("in"), out("out"),
    vcc("vcc"), highside("highside"), lowside("lowside"), node("node"), gnd("gnd")
  {
    vcc.offset = vcc_;  // usage as constant voltage source
    vcc.p(node);
    vcc.n(gnd);

    highside.ctrl(in);  // 1st switch
    highside.p(node);
    highside.n(out);

    lowside.ctrl(in);   // 2nd switch...
    lowside.p(out);
    lowside.n(gnd);
    lowside.off_state = true; // ...is inverted
  }

 private:
  sca_eln::sca_node node;
  sca_eln::sca_node_ref gnd;
};

SC_MODULE(load)
{
  sca_eln::sca_terminal p, n;

  sca_eln::sca_r r;
  sca_eln::sca_l l;

  load( sc_core::sc_module_name nm, 
        double res_ = 500.0, double ind_ = 0.000001 )
  : p("p"), n("n"), r("r", res_ ), l("l", ind_ ), node("node")
  {
    r.p(p);
    r.n(node);

    l.p(node);
    l.n(n);
  }

 private:
  sca_eln::sca_node node;
};


int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  sca_eln::sca_node n1;
  sca_eln::sca_node_ref gnd;

  sc_core::sc_signal<bool> sc_sig;
  
  pwm_driver pwm("pwm");
    pwm.in(sc_sig);
    pwm.out(n1);
    pwm.vcc.set_timestep(1.0, sc_core::SC_MS);

  load ld("ld");
    ld.p(n1);
    ld.n(gnd);    

  sc_core::sc_start(10.0, sc_core::SC_MS);
  
  TEST_LABEL_END;
    
  return 0;
}
