/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// bask_demod.h with public tracing method

#include <systemc-ams>

#include "rectifier.h"
#include "ltf_nd_filter.h"
#include "sampler.h"

SC_MODULE(bask_demod)
{
  sca_tdf::sca_in<double> in;
  sca_tdf::sca_out<bool>  out;

  rectifier     rc;
  ltf_nd_filter lp;
  sampler       sp;

  SC_CTOR(bask_demod) 
  : in("in"), out("out"), rc("rc"), lp("lp", 3.3e6), sp("sp"), rc_out("rc_out"), lp_out("lp_out")
  {
    rc.in(in);
    rc.out(rc_out);

    lp.in(rc_out);
    lp.out(lp_out);

    sp.in(lp_out);
    sp.out(out);
  }
  
  void trace_internals( sca_util::sca_trace_file* tf )
  {
    sca_util::sca_trace(tf, rc_out, rc_out.name() );
    sca_util::sca_trace(tf, lp_out, lp_out.name() );
  }

 private:
  sca_tdf::sca_signal<double> rc_out, lp_out;
};


