/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

#include <systemc-ams>
#include "test_utilities.h"

SC_MODULE(my_lsf_filter)
{
  sca_lsf::sca_in x;
  sca_lsf::sca_out y;

  sca_lsf::sca_sub sub1;
  sca_lsf::sca_dot dot1;

  my_lsf_filter( sc_core::sc_module_name, double h0 = 1.0, double fc = 1.0e3 )
  : x("x"), y("y"), sub1("sub1", h0), dot1("dot1", 1.0/(2.0 * M_PI * fc) ), sig("sig")
  {
    sub1.x1(x);
    sub1.x2(sig);
    sub1.y(y);

    dot1.x(y);
    dot1.y(sig);
  }

 private:
  sca_lsf::sca_signal sig;
};

int sc_main(int argc, char* argv[])
{
  sc_core::sc_set_time_resolution(1.0, sc_core::SC_FS);
  
  TEST_LABEL_START;

  sca_lsf::sca_signal s1, s2;
  
  double init_value = 0.0;
  double offset = 1.0;
  double amplitude = 0.0;
  double frequency = 0.0;
  double phase = 0.0;
  sca_core::sca_time delay = sca_core::sca_time(0.5, sc_core::SC_MS);
  
  sca_lsf::sca_source lsf_source("lsf_source1", init_value, offset, amplitude,
                                 frequency, phase, delay ); // step function
    lsf_source.y(s1);
    lsf_source.set_timestep(0.25, sc_core::SC_MS);
      
  my_lsf_filter filter("filter"); 
    filter.x(s1);
    filter.y(s2);

  sca_util::sca_trace_file* tf = sca_util::sca_create_tabular_trace_file("my_lsf_filter");
  sca_util::sca_trace(tf, s1, "s1");
  sca_util::sca_trace(tf, s2, "s2");

  sc_core::sc_start(3, sc_core::SC_MS);
  
  sca_util::sca_close_tabular_trace_file(tf);
  
  test_util::check_results("my_lsf_filter", 2);

  TEST_LABEL_END;
  
  return 0;
    
  
}
