/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/
// user's guide example my_structural_eln_model

#include <systemc-ams>
#include "test_utilities.h"

SC_MODULE(my_structural_eln_model)
{
  sca_eln::sca_terminal a;
  sca_eln::sca_terminal b;

  sca_eln::sca_r r1, r2;
  sca_eln::sca_c c1;

  SC_CTOR(my_structural_eln_model)
  : a("a"), b("b"), r1("r1", 10e3), r2("r2", 100.0), c1("c1", 100e-6), net1("net1"), gnd("gnd") 
  {
    r1.p(a);
    r1.n(b);

    r2.p(a);
    r2.n(net1);

    c1.p(net1);
    c1.n(gnd);
  }

 private:
  sca_eln::sca_node net1;
  sca_eln::sca_node_ref gnd;
};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  sca_eln::sca_node net1;
  
  my_structural_eln_model eln_mod("eln_mod");

  TEST_LABEL_END;
    
  return 0;
}
