/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

#include <systemc-ams>
#include "test_utilities.h"

#include "pwm.h"
#include "pi_ctrl.h"
#include "diff.h"
#include "ref_src.h"
#include "drv_motor.h"

int sc_main(int argc, char* argv[])
{
  TEST_LABEL_START;

  sc_core::sc_set_time_resolution(1.0, sc_core::SC_FS);

  sca_tdf::sca_signal<double> iref, ierr, imeas, ictrl, vdrv;

  ref_src ref_src1("ref_src1", 100);
   ref_src1.out(iref);

  diff diff1("diff1");
   diff1.ref(iref);
   diff1.meas(imeas);
   diff1.err(ierr);

  pi_ctrl pi_ctrl1("pi_ctrl1", 2.0, 5.0);
   pi_ctrl1.in(ierr);
   pi_ctrl1.out(ictrl);

  pwm pwm1("pwm1");
   pwm1.in(ictrl);
   pwm1.out(vdrv);

  drv_motor drv_motor1("drv_motor1");
   drv_motor1.in(vdrv);
   drv_motor1.out(imeas);

  sca_util::sca_trace_file* tf = sca_util::sca_create_tabular_trace_file("pwm");
  sca_util::sca_trace(tf, iref, "iref");
  sca_util::sca_trace(tf, imeas, "imeas");
  sca_util::sca_trace(tf, ierr, "ierr");
  sca_util::sca_trace(tf, ictrl, "ictrl");
  sca_util::sca_trace(tf, vdrv, "vdrv");

  sc_start(0.2, sc_core::SC_SEC);

  sca_util::sca_close_tabular_trace_file(tf);

  TEST_LABEL_END;

  return 0;
}
