/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test if sca_core::sca_port is derived from sc_core::sc_port

#include <systemc-ams>
#include "test_utilities.h"

template <class T>
class myport: public sca_core::sca_port<sc_core::sc_signal_in_if<T> >
{
  public:
    myport() {}
};

class my_module : public sca_tdf::sca_module
{
public:
  my_module( sc_core::sc_module_name nm )
  {
    // check if the base class pointer is valid
    sc_core::sc_port<sc_core::sc_signal_in_if<double >, 1,
    sc_core::SC_ONE_OR_MORE_BOUND>* in = new
    myport<double>();

    //show kind of the base class object
    std::cout << in->sc_core::sc_port<sc_core::sc_signal_in_if<double >, 1,
    sc_core::SC_ONE_OR_MORE_BOUND>::kind() << std::endl;
  }
};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  my_module my_module1("my_module1");

  TEST_LABEL_END;

  return 0;
}
