/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test sca_parameter set, get, loc, unlock
// test if sca_parameter is derived from sca_parameter_base

#include <systemc-ams>
#include "test_utilities.h"

SC_MODULE( my_module )
{
  // some parameters

  sca_core::sca_parameter<double>      p1;
  sca_core::sca_parameter<int>         p2;
  sca_core::sca_parameter<std::string> p3;

  SC_CTOR(my_module)
    : p1()               // default constructed; no name and no default value
    , p2( "p2" )         // name given, but no default value
    , p3( "p3", "foo" )  // initialised with name and value (good coding practice)
  {}
};

template< typename T >
void show_param( const char* n, const sca_core::sca_parameter<T> & p, const T& v )
{
  std::cout
    << n
    << "\n .name()      = '" << p.name()      << "'"
    << "\n .kind()      = '" << p.kind()      << "'"
    << "\n .get()       = '" << p.get()       << "'"
    << "\n .to_string() = '" << p.to_string() << "'"
    << "\n const &      = '" << v             << "'"
    << "\n .print()     = '";

  p.print();
  std::cout << "'\n" << std::endl;
}

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  my_module m("m");

  double const &      p1_ref = m.p1;
  int    const &      p2_ref = m.p2;
  std::string const & p3_ref = m.p3;

  //test whether derived from sca_parameter_base
  sca_core::sca_parameter_base* ptr = &m.p1;

  // show parameters only for p3, as values for p1 and p2 are unknown

  show_param( "m.p3", m.p3, p3_ref  );

  std::cout << "-----------------" << std::endl;

  // test lock parameters method

  m.p1.lock();
  m.p2.lock();
  m.p3.lock();

  // unlock parameters

  m.p1.unlock();
  m.p2.unlock();
  m.p3.unlock();

  // set some values (test different ways)

  m.p1 = 42.17;
  m.p2.set( 23 );
  m.p3 = m.p1.to_string();

  // show parameters again

  show_param( "m.p1", m.p1, p1_ref );
  show_param( "m.p2", m.p2, p2_ref  );
  show_param( "m.p3", m.p3, p3_ref  );

  TEST_LABEL_END;
  return 0;
}
