/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

//  test_sca_close_tabular_trace_file_after_ac_analysis.cpp --
// test tracing: closing of tfp_ac caused segfault in BETA1 release

#include <systemc-ams>
#include "test_utilities.h"

int sc_main(int argc, char* argv[])
{
  using namespace std;
  using namespace sc_core;
  using namespace sca_util;

  TEST_LABEL_START;

  sca_lsf::sca_signal src1_sig("src1_sig");

  sca_lsf::sca_source src1("src1",
                           0.0, 0.0, 1.0, 50.0, 0.0, sc_core::SC_ZERO_TIME,
                           1.0, 0.0, 0.0);
  src1.y(src1_sig);
  src1.set_timestep(1.0, sc_core::SC_MS);

  // Transient analysis with tracing
  sca_trace_file* tfp_tran = sca_create_tabular_trace_file("tran_analysis");
  sca_trace(tfp_tran, src1_sig, "src1_sig");
  sc_start(100.0, sc_core::SC_MS);
  sca_close_tabular_trace_file(tfp_tran);  
  // tfp_tran closed without segfault.
  
  sca_trace_file* tfp_ac = sca_create_tabular_trace_file("ac_analysis");

  tfp_ac->set_mode(sca_util::sca_ac_format(sca_util::SCA_AC_DB_DEG));
  sca_trace(tfp_ac, src1_sig, "src1_sig");

  sca_ac_analysis::sca_ac_start(1.0, 1.0e6, 61, sca_ac_analysis::SCA_LOG);

  sca_close_tabular_trace_file(tfp_ac);
  // Closing of tfp_ac causes segfault.

  TEST_LABEL_END;
  
  return 0;
}
