/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

//  test_close_trace_file_wo_analysis.cpp --
// test tracing: closing of tfp_ac caused segfault in BETA1 release

#include <cassert>
#include <iostream>
#include <systemc-ams>
#include "test_utilities.h"

int sc_main(int argc, char* argv[])
{
  TEST_LABEL_START;

  std::cout << "Opening trace file." << std::endl;
  sca_util::sca_trace_file* tf = sca_util::sca_create_tabular_trace_file("test_trace_file");

  assert(tf);

  std::cout << "Closing trace file." << std::endl;

  // Closing the trace file w/o having done an analysis should not make
  // the application segfault.
  sca_util::sca_close_tabular_trace_file(tf);

  TEST_LABEL_END;

  return 0;
}
