/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

#include <systemc>
#include <systemc-ams>
#include "test_utilities.h"

// =============================================================
// The example below unveils a bug of LSF when AC simulation is
// started w/o transient simulation is started first:
// "Initialization equation system failed in sca_linear_solver<...>"
//
// You need at least two elements, it will not fail with the
// source alone.
// 
// At least a proper error message (like "sc_start missing")
// would be expected with sca_ac_start if required for initialisation.

// the DUT
SC_MODULE(lsf_simple)
{
  //instances
  sca_lsf::sca_source i_source;
  sca_lsf::sca_integ i_integ;

  //nodes
  sca_lsf::sca_signal x;
  sca_lsf::sca_signal y;

  //constructor
  SC_CTOR(lsf_simple)
  : i_source("i_source", 0.0, 0.0, 1.0, 1.0e6, 0.0, sc_core::SC_ZERO_TIME, 1.0, 0.0, 0.0),
    i_integ("i_integ", 1.0, 0.0),
    x("x"),
    y("y")
  {
    // simple path
    i_source.y(x);
    i_source.set_timestep(1, sc_core::SC_NS);
    i_integ.x(x);
    i_integ.y(y);
  }

};

// =============================================================
// SC MAIN as simple test bench

int sc_main(int argc, char* argv[])
{
  // matches timestep setup in DUT
  sc_core::sc_set_time_resolution(1.0, sc_core::SC_NS);
  
  TEST_LABEL_START;

  // this is the VCVS DUT example
  lsf_simple dut("dut");

  // run AC simulation
  sca_util::sca_trace_file* tf_ac = sca_util::sca_create_tabular_trace_file("ac.dat");
  sca_util::sca_trace(tf_ac, dut.x, "X");
  sca_util::sca_trace(tf_ac, dut.y, "Y");

  sca_ac_analysis::sca_ac_start(1.0e-1, 1.0e2, 15, sca_ac_analysis::SCA_LOG );

  sca_util::sca_close_tabular_trace_file(tf_ac);

  TEST_LABEL_END;

  return 0;
}
