/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test if a TDF input port can be used to for AC analysis

#include <systemc-ams>
#include "test_utilities.h"

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  sc_core::sc_signal<double> ctrl_sig;
  sca_eln::sca_node n1;
  sca_eln::sca_node_ref gnd;

  sca_eln::sca_de::sca_isource isrc("isrc");
    isrc.p(n1);
    isrc.n(gnd);
    isrc.inp(ctrl_sig);

  sca_eln::sca_r r1("r1");
    r1.p(n1);
    r1.n(gnd);
    r1.set_timestep(1.0, sc_core::SC_US);

  ctrl_sig.write(1.0);

  sca_ac_analysis::sca_ac_start(10.0, 100.0, 11, sca_ac_analysis::SCA_LOG);

  TEST_LABEL_END;

  return 0;
}
