/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

#ifndef TEST_MACROS_H_
#define TEST_MACROS_H_

#define TEST_LABEL_START \
  sca_util::sca_information_off(); \
  std::cout << "test started" << std::endl;

#define TEST_LABEL_END \
  std::cout << "test ended" << std::endl;

#define TEST_LABEL_END_WITHOUT_ERROR \
  std::cout << "test ended without expected error!" << std::endl;

#define TEST_LABEL_END_WITHOUT_WARNING \
  std::cout << "test ended without expected warning!" << std::endl;

#ifndef TEST_CPLUSPLUS
# ifdef _MSC_VER // don't rely on __cplusplus for MSVC
// Instead, we select the C++ standard with reasonable support.
// If some features still need to be excluded on specific MSVC
// versions, we'll do so at the point of definition.

#   if defined(_MSVC_LANG) // MSVC'2015 Update 3 or later, use compiler setting
#     define TEST_CPLUSPLUS _MSVC_LANG
#   elif _MSC_VER < 1800   // MSVC'2010 and earlier, assume C++03
#     define TEST_CPLUSPLUS 199711L
#   elif _MSC_VER < 1900   // MSVC'2013, assume C++11
#     define TEST_CPLUSPLUS 201103L
#   else                   // MSVC'2015 before Update 3, assume C++14
#     define TEST_CPLUSPLUS 201402L
#   endif

# else // not _MSC_VER
// use compiler setting
#   define TEST_CPLUSPLUS __cplusplus

# endif // not _MSC_VER
#endif // TEST_CPLUSPLUS

#endif // TEST_MACROS_H_
