/**
 *
 * @file tg_token.hh
 * @author Lasse Lehtonen
 *
 *
 */

/*
 * Copyright 2010 Tampere University of Technology
 * 
 *  This file is part of Transaction Generator.
 *
 *  Transaction Generator is free software: you can redistribute it
 *  and/or modify it under the terms of the Lesser GNU General Public
 *  License as published by the Free Software Foundation, either
 *  version 3 of the License, or (at your option) any later version.
 *
 *  Transaction Generator is distributed in the hope that it will be
 *  useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public
 *  License along with Transaction Generator.  If not, see
 *  <http://www.gnu.org/licenses/>.
 */

/*
 * $Id: tg_token.hh 1916 2011-07-06 12:44:26Z lehton87 $
 *
 */

#ifndef SCTG_TG_TOKEN_HH
#define SCTG_TG_TOKEN_HH

#include <systemc>

/** Token command type
 *
 * Defines whether this token represents a write or read command to
 * memories or a cache miss reading.
 *
 */
enum RWtype {READ_CMD, WRITE_CMD, CACHE_MISS};


/** Data token
 *
 * Tokens represent data transactions in task-to-task,
 * task-to/from-memory and event-to-task communication. Tokens are
 * potentially sliced into smaller packets for over NoC transactions
 * and constructed again on the receiving buffer.
 *
 * @see tgPacket
 *
 */
struct tgToken
{
   unsigned long int source;       ///< Source port ID
   unsigned long int destination;  ///< Destination port ID
   unsigned long int returnPort;   ///< Return port ID for memory reads
   unsigned long int size;         ///< Payload size in bytes
   unsigned long int respSize;     ///< Memory read response size in bytes
   unsigned long int burstSize;    ///< How big bursts used to accesss memory
   unsigned long int id;           ///< Unique ID for this token
   unsigned long int packets;      ///< To how many packets token is split
   bool              isEvent;      ///< True if this came from event
   sc_core::sc_time  timeSent;     ///< Time when token was sent
   sc_core::sc_time  timeReceived; ///< Time when token was received
   RWtype            type;         ///< For memory accesses: read or write

   /** Constructor to initialize all values to safe defaults
    */
   tgToken()
      : source(0),
	destination(0),
	returnPort(0),
	size(0),
	respSize(0),
	burstSize(0),
	id(0),
	packets(1),
	isEvent(false),
	type(WRITE_CMD)
   {
   }
};

#endif


// Local Variables:
// mode: c++
// c-file-style: "ellemtel"
// c-basic-offset: 3
// End:
