/**
 *
 * @file non_sc_factory.hh
 * @author Lasse Lehtonen
 *
 * Factory for classes that has nothing to do with SystemC
 * Needed to separate classes that some compilers can't handle
 *
 */

/*
 * Copyright 2010 Tampere University of Technology
 * 
 *  This file is part of Transaction Generator.
 *
 *  Transaction Generator is free software: you can redistribute it
 *  and/or modify it under the terms of the Lesser GNU General Public
 *  License as published by the Free Software Foundation, either
 *  version 3 of the License, or (at your option) any later version.
 *
 *  Transaction Generator is distributed in the hope that it will be
 *  useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public
 *  License along with Transaction Generator.  If not, see
 *  <http://www.gnu.org/licenses/>.
 */

/*
 * $Id: non_sc_factory.hh 1916 2011-07-06 12:44:26Z lehton87 $
 *
 */

#ifndef SCTG_NON_SC_FACTORY_HH
#define SCTG_NON_SC_FACTORY_HH

#include "tcp_server_if.hh"
#include "non_sc_conf_if.hh"

namespace sctg
{
   /** Factory class to allow separate compilation for some classes
    * that wouldn't compile easily with Modelsim's sccom
    */
   class NonScFactory
   {
   public:
      
      /** Constructor
       */
      NonScFactory(sctg::NonScConfIf& conf);

      /** Destructor
       */
      virtual ~NonScFactory();



   private:

      NonScConfIf& _conf;
      TcpServerIf* _tcpServerIf;

   };
}

#endif



// Local Variables:
// mode: c++
// c-file-style: "ellemtel"
// c-basic-offset: 3
// End:

