/**
 *
 * @file measure.hh
 * @author Lasse Lehtonen
 *
 *
 */

/*
 * Copyright 2010 Tampere University of Technology
 * 
 *  This file is part of Transaction Generator.
 *
 *  Transaction Generator is free software: you can redistribute it
 *  and/or modify it under the terms of the Lesser GNU General Public
 *  License as published by the Free Software Foundation, either
 *  version 3 of the License, or (at your option) any later version.
 *
 *  Transaction Generator is distributed in the hope that it will be
 *  useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public
 *  License along with Transaction Generator.  If not, see
 *  <http://www.gnu.org/licenses/>.
 */

/*
 * $Id: measure.hh 1923 2011-08-08 09:41:57Z lehton87 $
 *
 */


#ifndef SCTG_MEASURE_HH
#define SCTG_MEASURE_HH

#include "configuration.hh"
#include "processing_element.hh"
#include "common.hh"
#include "memory_model.hh"

#include <systemc>
#include <iostream>
#include <string>

namespace sctg
{
   /** Class for collecting emasurement data
    */
   class Measure : public sc_core::sc_module
   {
   public:
      SC_HAS_PROCESS(Measure);

      /** Constructor
       *
       * @param [in] name Tkdsol
       */
      Measure(sc_core::sc_module_name name, sctg::Configuration& config,
	      std::vector<sctg::ProcessingElement*> pes,
	      std::vector<sctg::Task*> tasks,
	      std::vector<sctg::MemoryModel*> memories,
	      std::vector<sctg::MemArea*> memAreas);

      /** Destructor
       */
      virtual ~Measure();

    
      /** Thread for measurements (not Execution Monitor)
       */
      void measureThread();

#ifdef SCTG_USE_EXECMON
      /** Thread for Execution Monitor
       */
      void execMonThread();
#endif      

   private:

      /** String containing timestamp for log files
       */
      std::string _measure_start_time;

      Configuration& _config;
      std::vector<sctg::ProcessingElement*> _pes;
      std::vector<sctg::Task*> _tasks;
      std::vector<sctg::MemoryModel*> _memories;
      std::vector<sctg::MemArea*> _memAreas;
   };
}

#endif



// Local Variables:
// mode: c++
// c-file-style: "ellemtel"
// c-basic-offset: 3
// End:
