#!/usr/bin/bash

#times="0.000005 0.0000025 0.000002 0.0000015 0.000001 0.0000008 0.0000005 0.0000004 0.00000035 0.0000003"
times="0.00000500 0.00000040 0.00000050 0.00000080 0.00000100 0.00000150 0.00000200 0.00000250"

nocs="sc_rtl_1 sc_rtl_2 sc_tlm_1"
msims="vhd sc_rtl_1 sc_rtl_2 sc_tlm_1"

started=`date`

agents="36 64 16"

echo "Starting : $started" > SIM_REPORT.txt

for a in $agents
do

    for i in $times
    do


	sed "s/EVENT_PERIOD/$i/g" app_mesh_${a}.xml > tmp.xml
	sed -i "s/BYTE_AMOUNT/16/g" tmp.xml
	sed -i "s/PACKET_SIZE/16/g" tmp.xml
	sed -i "s/RX_BUFF_SIZE/0/g" tmp.xml
	sed -i "s/TX_BUFF_SIZE/0/g" tmp.xml
	sed -i "s/NOC_CLASS/mesh_2d/g" tmp.xml


	if [ "${a}" = "16" ]; then
	    sed -i "s/NOC_SUBTYPE/4x4/g" tmp.xml    
	else 
	    if [ "${a}" = "36" ]; then
		sed -i "s/NOC_SUBTYPE/6x6/g" tmp.xml    
	    else
		sed -i "s/NOC_SUBTYPE/8x8/g" tmp.xml    
	    fi
	fi

	for j in $nocs
	do
	    sed "s/NOC_TYPE/$j/g" tmp.xml > sim.xml
	    sed -i "s/SUMMARY_FILE/sum_${a}_GCC_${j}_$i.txt/g" sim.xml
	    echo "`date` : doink res_${a}_GCC_${j}_$i.txt" >> SIM_REPORT.txt
	    (time ./sctg -i sim.xml) 2> res_${a}_GCC_${j}_$i.txt	
	done        

	for j in $msims
	do
	    sed "s/NOC_TYPE/$j/g" tmp.xml > sim.xml
	    sed -i "s/SUMMARY_FILE/sum_${a}_MSIM_${j}_$i.txt/g" sim.xml
	    echo "`date` : doink res_${a}_MSIM_${j}_$i.txt" >> SIM_REPORT.txt
	    (time make sim_mesh_3x3) 2> res_${a}_MSIM_${j}_$i.txt
	done


	sed "s/EVENT_PERIOD/$i/g" app_sbus_$a.xml > sim.xml
	sed -i "s/BYTE_AMOUNT/16/g" sim.xml
	sed -i "s/PACKET_SIZE/16/g" sim.xml
	sed -i "s/RX_BUFF_SIZE/0/g" sim.xml
	sed -i "s/TX_BUFF_SIZE/160000/g" sim.xml
	sed -i "s/NOC_CLASS/simple_bus/g" sim.xml
	sed -i "s/NOC_TYPE/sc_tlm_1/g" sim.xml
	sed -i "s/NOC_SUBTYPE/${a}_agents/g" sim.xml
	sed -i "s/SUMMARY_FILE/sum_${a}_GCC_sbus_$i.txt/g" sim.xml
	echo "`date` : doink res_${a}_GCC_sbus_$i.txt" >> SIM_REPORT.txt
	(time ./sctg -i sim.xml) 2> res_${a}_GCC_sbus_$i.txt    

	sed "s/EVENT_PERIOD/$i/g" app_sbus_$a.xml > sim.xml
	sed -i "s/BYTE_AMOUNT/16/g" sim.xml
	sed -i "s/PACKET_SIZE/16/g" sim.xml
	sed -i "s/RX_BUFF_SIZE/0/g" sim.xml
	sed -i "s/TX_BUFF_SIZE/160000/g" sim.xml
	sed -i "s/NOC_CLASS/simple_bus/g" sim.xml
	sed -i "s/NOC_TYPE/sc_tlm_1/g" sim.xml
	sed -i "s/NOC_SUBTYPE/${a}_agents/g" sim.xml
	sed -i "s/SUMMARY_FILE/sum_${a}_MSIM_sbus_$i.txt/g" sim.xml
	echo "`date` : doink res_${a}_MSIM_sbus_$i.txt" >> SIM_REPORT.txt
	(time make sim_sbus_9) 2> res_${a}_MSIM_sbus_$i.txt
	
    done
    
done

finished=`date`

echo "Started:  $started"  >> SIM_REPORT.txt
echo "Finished: $finished" >> SIM_REPORT.txt
