/**
 *
 * @file sbus_factory.cc
 * @author Lasse Lehtonen
 *
 *
 */

/*
 * Copyright 2010 Tampere University of Technology
 * 
 *  This file is part of Transaction Generator.
 *
 *  Transaction Generator is free software: you can redistribute it and/or modify
 *  it under the terms of the Lesser GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Transaction Generator is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public License
 *  along with Transaction Generator.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * $Id: sbus_factory.cc 1399 2010-08-26 13:56:45Z lehton87 $
 *
 */


#include "sbus_factory.hh"

#include <systemc>

#include <iostream>
#include <stdexcept>
#include <string>

namespace asebt
{
   
   SBusFactory::SBusFactory(sctg::NocConfIf* nocConfIf)
      :
      _adapter_4(0),
      _bus_4(0),
      _adapter_9(0),
      _bus_9(0),
      _adapter_16(0),
      _bus_16(0),
      _adapter_25(0),
      _bus_25(0),
      _adapter_36(0),
      _bus_36(0),
      _adapter_64(0),
      _bus_64(0)
   {   
      std::string nocClass   = nocConfIf->getNocClass();
      std::string nocType    = nocConfIf->getNocType();
      std::string nocSubType = nocConfIf->getNocSubType();

      if(nocClass == "simple_bus")
      {
	 if(nocType == "sc_tlm_1" and nocSubType == "4_agents")
	 {
	    _adapter_4 = new sctg::SctgToOsciTlm<4, 32>("adapter", nocConfIf);
	    _bus_4 = new asebt::SimpleBus<4, 32>("Simple_bus", nocConfIf);
	    for(unsigned int i = 0; i < 4; ++i)
	    {
	       _adapter_4->initSockets[i].bind(_bus_4->targetSockets[i]);
	       _bus_4->initSockets[i].bind(_adapter_4->targetSockets[i]);
	    }
	 }
	 else if(nocType == "sc_tlm_1" and nocSubType == "9_agents")
	 {
	    _adapter_9 = new sctg::SctgToOsciTlm<9, 32>("adapter", nocConfIf);
	    _bus_9 = new asebt::SimpleBus<9, 32>("Simple_bus", nocConfIf);
	    for(unsigned int i = 0; i < 9; ++i)
	    {
	       _adapter_9->initSockets[i].bind(_bus_9->targetSockets[i]);
	       _bus_9->initSockets[i].bind(_adapter_9->targetSockets[i]);
	    }
	 }
	 else if(nocType == "sc_tlm_1" and nocSubType == "16_agents")
	 {
	    _adapter_16 = new sctg::SctgToOsciTlm<16, 32>("adapter", nocConfIf);
	    _bus_16 = new asebt::SimpleBus<16, 32>("Simple_bus", nocConfIf);
	    for(unsigned int i = 0; i < 16; ++i)
	    {
	       _adapter_16->initSockets[i].bind(_bus_16->targetSockets[i]);
	       _bus_16->initSockets[i].bind(_adapter_16->targetSockets[i]);
	    }
	 }
	 else if(nocType == "sc_tlm_1" and nocSubType == "25_agents")
	 {
	    _adapter_25 = new sctg::SctgToOsciTlm<25, 32>("adapter", nocConfIf);
	    _bus_25 = new asebt::SimpleBus<25, 32>("Simple_bus", nocConfIf);
	    for(unsigned int i = 0; i < 25; ++i)
	    {
	       _adapter_25->initSockets[i].bind(_bus_25->targetSockets[i]);
	       _bus_25->initSockets[i].bind(_adapter_25->targetSockets[i]);
	    }
	 }
	 else if(nocType == "sc_tlm_1" and nocSubType == "36_agents")
	 {
	    _adapter_36 = new sctg::SctgToOsciTlm<36, 32>("adapter", nocConfIf);
	    _bus_36 = new asebt::SimpleBus<36, 32>("Simple_bus", nocConfIf);
	    for(unsigned int i = 0; i < 36; ++i)
	    {
	       _adapter_36->initSockets[i].bind(_bus_36->targetSockets[i]);
	       _bus_36->initSockets[i].bind(_adapter_36->targetSockets[i]);
	    }
	 }
	 else if(nocType == "sc_tlm_1" and nocSubType == "64_agents")
	 {
	    _adapter_64 = new sctg::SctgToOsciTlm<64, 32>("adapter", nocConfIf);
	    _bus_64 = new asebt::SimpleBus<64, 32>("Simple_bus", nocConfIf);
	    for(unsigned int i = 0; i < 64; ++i)
	    {
	       _adapter_64->initSockets[i].bind(_bus_64->targetSockets[i]);
	       _bus_64->initSockets[i].bind(_adapter_64->targetSockets[i]);
	    }
	 }
	 else
	 {
	    std::ostringstream oss;
	    oss << "SBusFactory: NoC with class \"" << nocClass 
		<< "\", type \"" << nocType 
		<< "\" and subtype \"" << nocSubType << "\" not found";
	    throw std::runtime_error(oss.str().c_str());
	 }
      }
      else
      {
	 std::ostringstream oss;
	 oss << "SBusFactory: NoC with class \"" << nocClass 
	     << "\" and type \"" << nocType << "\" not found";
	 throw std::runtime_error(oss.str().c_str());
      }
   }
   
   SBusFactory::~SBusFactory()
   {
      if(_adapter_4)  { delete _adapter_4;  _adapter_4  = 0; }
      if(_bus_4)      { delete _bus_4;      _bus_4      = 0; }
      if(_adapter_9)  { delete _adapter_9;  _adapter_9  = 0; }
      if(_bus_9)      { delete _bus_9;      _bus_9      = 0; }
      if(_adapter_16) { delete _adapter_16; _adapter_16 = 0; }
      if(_bus_16)     { delete _bus_16;     _bus_16     = 0; }
      if(_adapter_25) { delete _adapter_25; _adapter_25 = 0; }
      if(_bus_25)     { delete _bus_25;     _bus_25     = 0; }
      if(_adapter_36) { delete _adapter_36; _adapter_36 = 0; }
      if(_bus_36)     { delete _bus_36;     _bus_36     = 0; }
      if(_adapter_64) { delete _adapter_64; _adapter_64 = 0; }
      if(_bus_64)     { delete _bus_64;     _bus_64     = 0; }
   }
   
}



// Local Variables:
// mode: c++
// c-file-style: "ellemtel"
// c-basic-offset: 3
// End:

