/**
 *
 * @file ring_factory_vhd.cc
 * @author Lasse Lehtonen
 *
 *
 */

/*
 * Copyright 2010 Tampere University of Technology
 * 
 *  This file is part of Transaction Generator.
 *
 *  Transaction Generator is free software: you can redistribute it
 *  and/or modify it under the terms of the Lesser GNU General Public
 *  License as published by the Free Software Foundation, either
 *  version 3 of the License, or (at your option) any later version.
 *
 *  Transaction Generator is distributed in the hope that it will be
 *  useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public
 *  License along with Transaction Generator.  If not, see
 *  <http://www.gnu.org/licenses/>.
 */

/*
 * $Id: ring_factory_vhd.cc 1956 2011-08-22 14:41:32Z lehton87 $
 *
 */


#include "ring_factory_vhd.hh"


#include <string>
#include <stdexcept>
#include <iostream>
#include <map>

namespace sctg
{

   static int findGeneric(std::map<std::string, int>& m,
			  const std::string& s, 
			  int def)
   {
      if(m.find(s) != m.end())
      {
	 std::cout << "Generic " << s << " set to value " << m[s] << std::endl;
	 return m[s];
      }
      else
      {
	 std::cout << "Generic " << s 
		   << " set to default value " << def << std::endl;
	 return def;
      }
   }

   namespace ring_vhd
   {

      RingFactoryVHD::RingFactoryVHD(sctg::NocConfIf* nocConfIf)
      :
	 ringi3(0),
	 ringi4(0),
	 ringi5(0),
	 ringi6(0),
	 ringi7(0),
	 ringi8(0),
	 ringi16(0),
	 ringi32(0),
	 ringi64(0)
      {
	 std::string subtype = nocConfIf->getNocSubType();
	 std::map<std::string, int> nodes = nocConfIf->getGenerics();

	 int diag_en_g = findGeneric(nodes, "diag_en_g", 1);
	 int stfwd_en_g = findGeneric(nodes, "stfwd_en_g", 0);
	 int addr_width_g = findGeneric(nodes, "addr_width_g", 32);
	 int packet_length_g = findGeneric(nodes, "packet_length_g", 8);
	 int timeout_g = findGeneric(nodes, "timeout_g", 4);
	 int fill_packet_g = findGeneric(nodes, "fill_packet_g", 0);
	 int len_flit_en_g = findGeneric(nodes, "len_flit_en_g", 0);
	 int oaddr_flit_en_g = findGeneric(nodes, "oaddr_flit_en_g", 0);
	 int fifo_depth_g = findGeneric(nodes, "fifo_depth_g", 4);
	 int noc_freq_g = findGeneric(nodes, "noc_freq_g", 50000000);
	 int ip_freq_g = findGeneric(nodes, "ip_freq_g", 50000000);

	 if(subtype == "3")
	 {
	    ringi3 = new ring_with_pkt_codec_vhd_bfm<3, 32, 8>
	       ("ring_with_pkt_codec", nocConfIf,
		diag_en_g, stfwd_en_g, addr_width_g, packet_length_g,
		timeout_g, fill_packet_g, len_flit_en_g, oaddr_flit_en_g,
		fifo_depth_g, noc_freq_g, ip_freq_g);
	 }
	 else if(subtype == "4")
	 {
	    ringi4 = new ring_with_pkt_codec_vhd_bfm<4, 32, 8>
	       ("ring_with_pkt_codec", nocConfIf,
		diag_en_g, stfwd_en_g, addr_width_g, packet_length_g,
		timeout_g, fill_packet_g, len_flit_en_g, oaddr_flit_en_g,
		fifo_depth_g, noc_freq_g, ip_freq_g);
	 }
	 else if(subtype == "5")
	 {
	    ringi5 = new ring_with_pkt_codec_vhd_bfm<5, 32, 8>
	       ("ring_with_pkt_codec", nocConfIf,
		diag_en_g, stfwd_en_g, addr_width_g, packet_length_g,
		timeout_g, fill_packet_g, len_flit_en_g, oaddr_flit_en_g,
		fifo_depth_g, noc_freq_g, ip_freq_g);
	 }
	 else if(subtype == "6")
	 {
	    ringi6 = new ring_with_pkt_codec_vhd_bfm<6, 32, 8>
	       ("ring_with_pkt_codec", nocConfIf,
		diag_en_g, stfwd_en_g, addr_width_g, packet_length_g,
		timeout_g, fill_packet_g, len_flit_en_g, oaddr_flit_en_g,
		fifo_depth_g, noc_freq_g, ip_freq_g);
	 }
	 else if(subtype == "7")
	 {
	    ringi7 = new ring_with_pkt_codec_vhd_bfm<7, 32, 8>
	       ("ring_with_pkt_codec", nocConfIf,
		diag_en_g, stfwd_en_g, addr_width_g, packet_length_g,
		timeout_g, fill_packet_g, len_flit_en_g, oaddr_flit_en_g,
		fifo_depth_g, noc_freq_g, ip_freq_g);
	 }
	 else if(subtype == "8")
	 {
	    ringi8 = new ring_with_pkt_codec_vhd_bfm<8, 32, 8>
	       ("ring_with_pkt_codec", nocConfIf,
		diag_en_g, stfwd_en_g, addr_width_g, packet_length_g,
		timeout_g, fill_packet_g, len_flit_en_g, oaddr_flit_en_g,
		fifo_depth_g, noc_freq_g, ip_freq_g);
	 }
	 else if(subtype == "16")
	 {
	    ringi16 = new ring_with_pkt_codec_vhd_bfm<16, 32, 8>
	       ("ring_with_pkt_codec", nocConfIf,
		diag_en_g, stfwd_en_g, addr_width_g, packet_length_g,
		timeout_g, fill_packet_g, len_flit_en_g, oaddr_flit_en_g,
		fifo_depth_g, noc_freq_g, ip_freq_g);
	 }
	 else if(subtype == "32")
	 {
	    ringi32 = new ring_with_pkt_codec_vhd_bfm<32, 32, 8>
	       ("ring_with_pkt_codec", nocConfIf,
		diag_en_g, stfwd_en_g, addr_width_g, packet_length_g,
		timeout_g, fill_packet_g, len_flit_en_g, oaddr_flit_en_g,
		fifo_depth_g, noc_freq_g, ip_freq_g);
	 }
	 else if(subtype == "64")
	 {
	    ringi64 = new ring_with_pkt_codec_vhd_bfm<64, 32, 8>
	       ("ring_with_pkt_codec", nocConfIf,
		diag_en_g, stfwd_en_g, addr_width_g, packet_length_g,
		timeout_g, fill_packet_g, len_flit_en_g, oaddr_flit_en_g,
		fifo_depth_g, noc_freq_g, ip_freq_g);
	 }
	 else
	 {
	    std::ostringstream oss;
	    oss << "RingFactory (VHDL) unsupported subtype \""
		<< subtype << "\"";
	    throw std::runtime_error(oss.str().c_str());
	 }

      }

      RingFactoryVHD::~RingFactoryVHD()
      {
      }


   }
}


// Local Variables:
// mode: c++
// c-file-style: "ellemtel"
// c-basic-offset: 3
// End:

