/**
 *
 * @file ring_factory.cc
 * @author Lasse Lehtonen
 *
 *
 */

/*
 * Copyright 2010 Tampere University of Technology
 * 
 *  This file is part of Transaction Generator.
 *
 *  Transaction Generator is free software: you can redistribute it
 *  and/or modify it under the terms of the Lesser GNU General Public
 *  License as published by the Free Software Foundation, either
 *  version 3 of the License, or (at your option) any later version.
 *
 *  Transaction Generator is distributed in the hope that it will be
 *  useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public
 *  License along with Transaction Generator.  If not, see
 *  <http://www.gnu.org/licenses/>.
 */

/*
 * $Id: ring_factory.cc 1956 2011-08-22 14:41:32Z lehton87 $
 *
 */


#include "ring_factory.hh"

#include <systemc>

#include <iostream>
#include <stdexcept>
#include <string>

namespace sctg
{

   RingFactory::RingFactory(sctg::NocConfIf* nocConfIf)
#ifdef SCTG_MIXED_LANGUAGE_SIM
      :	_ring_vhd(0)
#endif
   {   
      std::string nocClass = nocConfIf->getNocClass();
      std::string nocType  = nocConfIf->getNocType();

#ifdef SCTG_MIXED_LANGUAGE_SIM
      if(nocType == "vhd")
      {
	 _ring_vhd = new sctg::ring_vhd::RingFactoryVHD(nocConfIf);
      }
      else
#endif
      {
	 std::ostringstream oss;
	 oss << "RingFactory: NoC with class \"" << nocClass 
	     << "\" and type \"" << nocType << "\" not found";
	 throw std::runtime_error(oss.str().c_str());
      }
   }

   RingFactory::~RingFactory()
   {
   }

}



// Local Variables:
// mode: c++
// c-file-style: "ellemtel"
// c-basic-offset: 3
// End:

