/**
 *
 * @file noc_factory.hh
 * @author Lasse Lehtonen
 *
 *
 */

/*
 * Copyright 2010 Tampere University of Technology
 * 
 *  This file is part of Transaction Generator.
 *
 *  Transaction Generator is free software: you can redistribute it and/or modify
 *  it under the terms of the Lesser GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Transaction Generator is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public License
 *  along with Transaction Generator.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * $Id: noc_factory.hh 1956 2011-08-22 14:41:32Z lehton87 $
 *
 */

#ifndef NOC_FACTORY_HH
#define NOC_FACTORY_HH

#include "mesh_factory.hh"
#include "sbus_factory.hh"
#include "crossbar_factory.hh"
#include "ring_factory.hh"

#include "noc_conf_if.hh"

#include <systemc>

class NocFactory
{
public:
   
   NocFactory(sctg::NocConfIf* nocConfIf);
   
   virtual ~NocFactory();      
   
private:   
   
   asebt::MeshFactory*                _mesh_factory;
   asebt::SBusFactory*                _sbus_factory;
   sctg::CrossbarFactory*             _crossbar_factory;
   sctg::RingFactory*                 _ring_factory;
   
   NocFactory(const NocFactory&);
   NocFactory& operator=(const NocFactory&);
};


#endif


// Local Variables:
// mode: c++
// c-file-style: "ellemtel"
// c-basic-offset: 3
// End:
