/**
 *
 * @file mesh_2d_with_pkt_codec_top.hh
 * @author Lasse Lehtonen
 *
 * @brief Foreign module declaration for mesh_2d_with_pkt_codec_top
 *
 */

/*
 * Copyright 2010 Tampere University of Technology
 * 
 *  This file is part of Transaction Generator.
 *
 *  Transaction Generator is free software: you can redistribute it and/or modify
 *  it under the terms of the Lesser GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Transaction Generator is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public License
 *  along with Transaction Generator.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * $Id: mesh_2d_with_pkt_codec_top.hh 1953 2011-08-22 08:38:32Z lehton87 $
 *
 */


#ifndef ASEBT_VHD_MESH_2D_WITH_PKT_CODEC_TOP_HH
#define ASEBT_VHD_MESH_2D_WITH_PKT_CODEC_TOP_HH

#include <systemc>

namespace asebt
{
namespace mesh_2d_vhd
{

   template < int n_ag_g, int stfwd_en_g, int data_width_g, int addr_width_g, 
	      int packet_length_g, int tx_len_width_g, int timeout_g, 
	      int fill_packet_g, int lut_en_g, int net_type_g, 
	      int len_flit_en_g, 
	      int oaddr_flit_en_g, int status_en_g, int fifo_depth_g, 
	      int mesh_freq_g, int ip_freq_g, int rows_g, int cols_g >
   class mesh_2d_with_pkt_codec_top : public sc_core::sc_foreign_module
   {
   public:
      sc_core::sc_in_clk clk_net; //<sc_dt::sc_logic> clk_net;
      sc_core::sc_in_clk clk_ip; //<sc_dt::sc_logic> clk_ip;
      sc_core::sc_in<sc_dt::sc_logic> rst_n;
      sc_core::sc_in<sc_dt::sc_lv<n_ag_g - 1 + 1> > av_in;
      sc_core::sc_in<sc_dt::sc_lv<n_ag_g * data_width_g - 1 + 1> > data_in;
      sc_core::sc_in<sc_dt::sc_lv<n_ag_g - 1 + 1> > we_in;
      sc_core::sc_in<sc_dt::sc_lv<n_ag_g * tx_len_width_g - 1 + 1> > txlen_in;
      sc_core::sc_out<sc_dt::sc_lv<n_ag_g - 1 + 1> > full_out;
      sc_core::sc_out<sc_dt::sc_lv<n_ag_g - 1 + 1> > tx_empty_out;
      sc_core::sc_out<sc_dt::sc_lv<n_ag_g - 1 + 1> > av_out;
      sc_core::sc_out<sc_dt::sc_lv<n_ag_g * data_width_g - 1 + 1> > data_out;
      sc_core::sc_in<sc_dt::sc_lv<n_ag_g - 1 + 1> > re_in;
      sc_core::sc_out<sc_dt::sc_lv<n_ag_g - 1 + 1> > rx_empty_out;
  
  
      mesh_2d_with_pkt_codec_top(sc_core::sc_module_name nm, const char* hdl_name)
	 : sc_foreign_module(nm),
	   clk_net("clk_net"),
	   clk_ip("clk_ip"),
	   rst_n("rst_n"),
	   av_in("av_in"),
	   data_in("data_in"),
	   we_in("we_in"),
	   txlen_in("txlen_in"),
	   full_out("full_out"),
	   tx_empty_out("tx_empty_out"),
	   av_out("av_out"),
	   data_out("data_out"),
	   re_in("re_in"),
	   rx_empty_out("rx_empty_out")
      {
	 this->add_parameter("n_ag_g", n_ag_g);
	 this->add_parameter("stfwd_en_g", stfwd_en_g);
	 this->add_parameter("data_width_g", data_width_g);
	 this->add_parameter("addr_width_g", addr_width_g);
	 this->add_parameter("packet_length_g", packet_length_g);
	 this->add_parameter("tx_len_width_g", tx_len_width_g);
	 this->add_parameter("timeout_g", timeout_g);
	 this->add_parameter("fill_packet_g", fill_packet_g);
	 this->add_parameter("lut_en_g", lut_en_g);
	 this->add_parameter("net_type_g", net_type_g);
	 this->add_parameter("len_flit_en_g", len_flit_en_g);
	 this->add_parameter("oaddr_flit_en_g", oaddr_flit_en_g);
	 this->add_parameter("status_en_g", status_en_g);
	 this->add_parameter("fifo_depth_g", fifo_depth_g);
	 this->add_parameter("mesh_freq_g", mesh_freq_g);
	 this->add_parameter("ip_freq_g", ip_freq_g);
	 this->add_parameter("rows_g", rows_g);
	 this->add_parameter("cols_g", cols_g);
	 elaborate_foreign_module(hdl_name);
      }
  
      ~mesh_2d_with_pkt_codec_top()
      {}
  
   };

}
}

#endif


// Local Variables:
// mode: c++
// c-file-style: "ellemtel"
// c-basic-offset: 3
// End:
