/**
 *
 * @file noc_factory.hh
 * @author Lasse Lehtonen
 *
 *
 */

/*
 * Copyright 2010 Tampere University of Technology
 * 
 *  This file is part of Transaction Generator.
 *
 *  Transaction Generator is free software: you can redistribute it and/or modify
 *  it under the terms of the Lesser GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Transaction Generator is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public License
 *  along with Transaction Generator.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * $Id: noc_factory.hh 1399 2010-08-26 13:56:45Z lehton87 $
 *
 */

#ifndef MESH_2D_SC_1_NOC_FACTORY_HH
#define MESH_2D_SC_1_NOC_FACTORY_HH

#include "mesh_2d_with_pkt_codec_sc_bfm.hh"
#include "noc_conf_if.hh"

#include <systemc>

namespace asebt
{
   namespace mesh_2d_sc_1
   {
      
      class NocFactoryRTL1
      {
      public:
	 
	 NocFactoryRTL1(sctg::NocConfIf* nocConfIf);
	 
	 virtual ~NocFactoryRTL1();      
	 
      private:
	 
	 mesh_2d_with_pkt_codec_sc_bfm<2,  // rows_g: Number of rows
				       2,  // cols_g: Number of columns
				       0,  // stfw_en_g: store and forward enable (1=enabled)
				       32, // data_width_g: Data bus width
				       32, // addr_width_g: Address bus width
				       8,  // packet_lenght_g: Packet length for pkt codec (words)
				       16, // tx_len_width_g: Num of bits for tx length
				       5,  // timeout_g: 
				       0,  // fill_packet_g: fill packet with dummy data, 1=yes
				       0,  // lut_en_g: Enable use of lut in pkt codec
				       0,  // net_type_g: Network type select, 0=mesh, 1=octagon
				       1,  // len_flit_en_g: Enable lenght flit
				       0,  // oaddr_flit_en_g: original address flit enable
				       0,  // status_en_g: status enable
				       4,  // fifo_depth_g: fifo depth (words)
				       5000000, //mesh_freq_g: mesh frequency, Hz
				       5000000>* _mesh_2x2; //ip_freq_g: ip frequency, Hz>* _mesh_2x2;
	 mesh_2d_with_pkt_codec_sc_bfm<3,
				       3,
				       0, 
				       32,
				       32,
				       8, 
				       16,
				       5, 
				       0, 
				       0, 
				       0, 
				       1, 
				       0, 
				       0, 
				       4, 
				       5000000,
				       5000000>* _mesh_3x3;
	 mesh_2d_with_pkt_codec_sc_bfm<4, 
				       4,
				       0, 
				       32,
				       32,
				       8, 
				       16,
				       5, 
				       0, 
				       0, 
				       0, 
				       1, 
				       0, 
				       0, 
				       4, 
				       5000000,
				       5000000>* _mesh_4x4;
	 mesh_2d_with_pkt_codec_sc_bfm<5, 
				       5,
				       0, 
				       32,
				       32,
				       8, 
				       16,
				       5, 
				       0, 
				       0, 
				       0, 
				       1, 
				       0, 
				       0, 
				       4, 
				       5000000,
				       5000000>* _mesh_5x5;
	 mesh_2d_with_pkt_codec_sc_bfm<6, 
				       6,
				       0, 
				       32,
				       32,
				       8, 
				       16,
				       5, 
				       0, 
				       0, 
				       0, 
				       1, 
				       0, 
				       0, 
				       4, 
				       5000000,
				       5000000>* _mesh_6x6;
	 mesh_2d_with_pkt_codec_sc_bfm<8, 
				       8,
				       0, 
				       32,
				       32,
				       8, 
				       16,
				       5, 
				       0, 
				       0, 
				       0, 
				       1, 
				       0, 
				       0, 
				       4, 
				       5000000,
				       5000000>* _mesh_8x8;
	 
      };
      
   }
}

#endif


// Local Variables:
// mode: c++
// c-file-style: "ellemtel"
// c-basic-offset: 3
// End:
