/**
 *
 * @file mesh_2d_top.hh
 * @author Lasse Lehtonen
 *
 *
 */

/*
 * Copyright 2010 Tampere University of Technology
 * 
 *  This file is part of Transaction Generator.
 *
 *  Transaction Generator is free software: you can redistribute it and/or modify
 *  it under the terms of the Lesser GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Transaction Generator is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public License
 *  along with Transaction Generator.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * $Id: mesh_2d_top.hh 1399 2010-08-26 13:56:45Z lehton87 $
 *
 */


#include "mesh_2d.hh"

#include <systemc>

#ifndef ASEBT_MESH_2D_SC_1_MESH_2D_TOP_HH
#define ASEBT_MESH_2D_SC_1_MESH_2D_TOP_HH

namespace asebt
{
namespace mesh_2d_sc_1
{
   namespace {
      const unsigned int rows = 3;
      const unsigned int cols = 3;
   }


   class mesh_2d_top : public sc_core::sc_module
   {
   public:

      SC_HAS_PROCESS(mesh_2d_top);

      mesh_2d_top(sc_core::sc_module_name name)
	 : sc_module(name),
	   rst_n("rst_n"),
	   mesh_2d_3x3("mesh_3x3")
      {
	 clk_ip = new sc_core::sc_clock("clk_ip", 
					sc_core::sc_time(20, sc_core::SC_NS));
	 clk_noc = new sc_core::sc_clock("clk_noc", 
					 sc_core::sc_time(20, sc_core::SC_NS));
    
	 mesh_2d_3x3.rst_n(rst_n);
	 mesh_2d_3x3.clk_mesh(*clk_noc);
	 mesh_2d_3x3.clk_ip(*clk_ip);
    
	 for(unsigned int r = 0; r < rows; ++r)
	 {
	    for(unsigned int c = 0; c < cols; ++c)
	    {
	       mesh_2d_3x3.tx_data_in[r][c](tx_data[r][c]);
	       mesh_2d_3x3.tx_we_in[r][c](tx_we[r][c]);
	       mesh_2d_3x3.rx_re_in[r][c](rx_re[r][c]);
	       mesh_2d_3x3.rx_data_out[r][c](rx_data[r][c]);
	       mesh_2d_3x3.rx_empty_out[r][c](rx_empty[r][c]);
	       mesh_2d_3x3.rx_full_out[r][c](rx_full[r][c]);
	       mesh_2d_3x3.tx_full_out[r][c](tx_full[r][c]);
	       mesh_2d_3x3.tx_empty_out[r][c](tx_empty[r][c]);
	    }
	 }
    
	 SC_THREAD(thread);

      }
  
      virtual ~mesh_2d_top()
      {
	 delete clk_ip;
	 delete clk_noc;
      }

      void thread()
      {
	 for(unsigned int r = 0; r < rows; ++r)
	 {
	    for(unsigned int c = 0; c < cols; ++c)
	    {
	       tx_data[r][c].write("0");
	       tx_we[r][c].write(sc_dt::SC_LOGIC_0);
	       rx_re[r][c].write(sc_dt::SC_LOGIC_0);
	    }
	 }

	 rst_n.write(sc_dt::SC_LOGIC_0);
	 wait(100, sc_core::SC_NS);
	 rst_n.write(sc_dt::SC_LOGIC_1);
    
	 wait(100, sc_core::SC_NS);
	 wait(clk_ip->posedge_event());

	 tx_data[0][0].write("00000000000000010000000000000001");
	 tx_we[0][0].write(sc_dt::SC_LOGIC_1);
    
	 wait(clk_ip->posedge_event());
    
	 tx_data[0][0].write("00000000000000000000000000000100");

	 wait(clk_ip->posedge_event());

	 tx_data[0][0].write("00000000000000000000000000000001");

	 wait(clk_ip->posedge_event());

	 tx_data[0][0].write("00000000000000000000000000000101");

	 wait(clk_ip->posedge_event());

	 tx_data[0][0].write("00000000000000000000000000000110");

	 wait(clk_ip->posedge_event());

	 tx_data[0][0].write("00000000000000000000000000000111");

	 wait(clk_ip->posedge_event());

	 tx_data[0][0].write("00000000000000000000000000000000");
	 tx_we[0][0].write(sc_dt::SC_LOGIC_0);

	 wait(clk_ip->posedge_event());

      }


   private:
  
      sc_core::sc_clock* clk_ip;
      sc_core::sc_clock* clk_noc;

      sc_core::sc_signal<sc_dt::sc_logic> rst_n;
  
      sc_core::sc_signal<sc_dt::sc_lv<32> >  tx_data[rows][cols];
      sc_core::sc_signal<sc_dt::sc_logic>    tx_we[rows][cols];
      sc_core::sc_signal<sc_dt::sc_logic>    rx_re[rows][cols];
      sc_core::sc_signal<sc_dt::sc_lv<32> >  rx_data[rows][cols];
      sc_core::sc_signal<sc_dt::sc_logic>    rx_empty[rows][cols];
      sc_core::sc_signal<sc_dt::sc_logic>    rx_full[rows][cols];
      sc_core::sc_signal<sc_dt::sc_logic>    tx_full[rows][cols];
      sc_core::sc_signal<sc_dt::sc_logic>    tx_empty[rows][cols];

      mesh_2d<4, //int fifo_depth_g, 
	      8, //int pkt_len_g, 
	      0, //int stfwd_en_g = 1, 
	      32, //int data_width_g = 16, 
	      32, //int addr_width_g = 16, 
	      1, //int len_flit_en_g = 1, 
	      0, //int oaddr_flit_en_g = 1, 
	      1, //int mesh_freq_g = 1, 
	      1, //int ip_freq_g = 1, 
	      rows, //int rows_g = 4, 
	      cols> //int cols_g = 4>
      mesh_2d_3x3;
  
   };

}
}

#endif


// Local Variables:
// mode: c++
// c-file-style: "ellemtel"
// c-basic-offset: 3
// End:
