/**
 *
 * @file ocp_tl3_factory.hh
 * @author Lasse Lehtonen
 *
 *
 */

/*
 * Copyright 2010 Tampere University of Technology
 * 
 *  This file is part of Transaction Generator.
 *
 *  Transaction Generator is free software: you can redistribute it and/or modify
 *  it under the terms of the Lesser GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Transaction Generator is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public License
 *  along with Transaction Generator.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * $Id: ocp_tl3_factory.hh 1399 2010-08-26 13:56:45Z lehton87 $
 *
 */

#ifndef MESH_2D_SC_OCP_TL3_FACTORY_HH
#define MESH_2D_SC_OCP_TL3_FACTORY_HH

#include "sctg_to_ocp_tl3.hh"
#include "sc_ocp_tl3_1/ocp_tl3_mesh_2d.hh"
#include "noc_conf_if.hh"

#include <systemc>

namespace sctg
{
   namespace mesh_2d_sc_ocp_tl3_1
   {
      
      class OcpTl3Factory
      {
      public:
	 
	 OcpTl3Factory(sctg::NocConfIf* nocConfIf);
	 
	 virtual ~OcpTl3Factory();
	 
      private:
	 
	 sctg::SctgToOcpTl3<4, 32>*  _adapter_4;
	 OcpTl3Mesh2D<32, 2, 2, 20>* _mesh_2x2;

	 sctg::SctgToOcpTl3<16, 32>*  _adapter_16;
	 OcpTl3Mesh2D<32, 4, 4, 20>* _mesh_4x4;

	 sctg::SctgToOcpTl3<36, 32>*  _adapter_36;
	 OcpTl3Mesh2D<32, 6, 6, 20>* _mesh_6x6;

	 sctg::SctgToOcpTl3<64, 32>*  _adapter_64;
	 OcpTl3Mesh2D<32, 8, 8, 20>* _mesh_8x8;
      };
      
   }
}

#endif


// Local Variables:
// mode: c++
// c-file-style: "ellemtel"
// c-basic-offset: 3
// End:
