/**
 *
 * @file multiclk_fifo.hh
 * @author Lasse Lehtonen
 *
 *
 */

/*
 * Copyright 2010 Tampere University of Technology
 * 
 *  This file is part of Transaction Generator.
 *
 *  Transaction Generator is free software: you can redistribute it and/or modify
 *  it under the terms of the Lesser GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Transaction Generator is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public License
 *  along with Transaction Generator.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * $Id: multiclk_fifo.hh 1399 2010-08-26 13:56:45Z lehton87 $
 *
 */


#ifndef ASEBT_SC_RTL_2_MULTICLK_FIFO_HH
#define ASEBT_SC_RTL_2_MULTICLK_FIFO_HH

#include "fifo.hh"

#include <systemc>

namespace asebt
{
namespace sc_rtl_2
{

   template <int re_freq_g, 
	     int we_freq_g, 
	     int depth_g, 
	     int data_width_g>
   class multiclk_fifo : public sc_core::sc_module
   {
   public:  

      sc_core::sc_in_clk clk_re;
      sc_core::sc_in_clk clk_we;
      sc_core::sc_in<bool> rst_n;
      sc_core::sc_in<sc_dt::sc_bv<data_width_g> > data_in;
      sc_core::sc_in<bool> we_in;
      sc_core::sc_out<bool> full_out;
      sc_core::sc_out<bool> one_p_out;
      sc_core::sc_in<bool> re_in;
      sc_core::sc_out<sc_dt::sc_bv<data_width_g> > data_out;
      sc_core::sc_out<bool> empty_out;
      sc_core::sc_out<bool> one_d_out;

      SC_HAS_PROCESS(multiclk_fifo);

      multiclk_fifo(sc_core::sc_module_name nm)
	 : sc_core::sc_module(nm),
	   clk_re("clk_re"),
	   clk_we("clk_we"),
	   rst_n("rst_n"),
	   data_in("data_in"),
	   we_in("we_in"),
	   full_out("full_out"),
	   one_p_out("one_p_out"),
	   re_in("re_in"),
	   data_out("data_out"),
	   empty_out("empty_out"),
	   one_d_out("one_d_out"),
	   _fifo("fifo")
      {
	 //data_in(data_to_fifo);
	 //full_out(full_from_fifo);
	 //one_p_out(one_p_from_fifo);
	 //data_out(data_from_fifo);
	 //empty_out(empty_from_fifo);
	 //one_d_out(one_d_from_fifo);

	 if(re_freq_g >= we_freq_g)
	 {
	    _fifo.clk(clk_re);
	 }
	 else
	 {
	    _fifo.clk(clk_we);
	 }

	 _fifo.rst_n(rst_n);
	 //fifo.data_in(data_to_fifo);
	 _fifo.data_in(data_in);
	 //fifo.we_in(we_to_fifo);
	 //fifo.full_out(full_from_fifo);
	 _fifo.full_out(full_out);
	 _fifo.one_p_out(one_p_out);    
	 //fifo.data_out(data_from_fifo);
	 _fifo.data_out(data_out);
	 //fifo.empty_out(empty_from_fifo);
	 _fifo.empty_out(empty_out);
	 _fifo.one_d_out(one_d_out);

	 re_to_fifo.write(false);
    

	 if(re_freq_g >= we_freq_g)
	 {
	    _fifo.re_in(re_in);
	    if(re_freq_g == we_freq_g)
	    { 
	       _fifo.we_in(we_in); 	    
	    }
	    else
	    {
	       _fifo.we_in(we_to_fifo);
	       SC_METHOD(method);
	       sensitive << clk_re.pos() << rst_n;
	    }
	 }
	 else
	 {
	    _fifo.we_in(we_in);
	    _fifo.re_in(re_to_fifo);

	    SC_METHOD(method);
	    sensitive << clk_we.pos() << rst_n;
	 }

  
      }

  
      virtual ~multiclk_fifo()
      {
      }

      void method()
      {
	 if(re_freq_g > we_freq_g)
	 {
	    if(rst_n.read() == false)
	    {
	       we_to_fifo = false;
	       re_cnt_r = 0;
	    }
	    else
	    {
	       if(we_in.read() == true)
	       {
		  if(re_cnt_r.read() == (re_freq_g/we_freq_g) - 2)
		  {
		     we_to_fifo = true;
		  }
		  else
		  {
		     we_to_fifo = false;
		  }

		  if(re_cnt_r.read() != (re_freq_g/we_freq_g) - 1)
		  {
		     re_cnt_r = re_cnt_r.read() + 1;
		  }
		  else
		  {
		     re_cnt_r = 0;
		  }
	       }
	       else
	       {
		  we_to_fifo = false;
		  re_cnt_r = 0;
	       }
	    }
	 }
	 else
	 {
	    if(rst_n.read() == false)
	    {
	       re_to_fifo = false;
	       we_cnt_r = 0;
	    }
	    else
	    {
	       if(re_in.read() == true)
	       {
		  if(we_cnt_r.read() == (we_freq_g/re_freq_g) - 2)
		  {
		     re_to_fifo = true;
		  }
		  else
		  {
		     re_to_fifo = false;
		  }

		  if(we_cnt_r.read() != (we_freq_g/re_freq_g) - 1)
		  {
		     we_cnt_r = we_cnt_r.read() + 1;
		  }
		  else
		  {
		     we_cnt_r = 0;
		  }
	       }
	       else
	       {
		  re_to_fifo = false;
		  we_cnt_r = 0;
	       }
	
	    }
	 }
      }

  
   private:
  
      sc_core::sc_signal<sc_dt::sc_uint<re_freq_g/we_freq_g> > re_cnt_r;
      sc_core::sc_signal<sc_dt::sc_uint<we_freq_g/re_freq_g> > we_cnt_r;

      //sc_core::sc_signal<sc_dt::sc_bv<data_width_g> > data_to_fifo;
      sc_core::sc_signal<bool> we_to_fifo;
      //sc_core::sc_signal<bool> full_from_fifo;
      //sc_core::sc_signal<bool> one_p_from_fifo;
      sc_core::sc_signal<bool> re_to_fifo;
      //sc_core::sc_signal<sc_dt::sc_bv<data_width_g> > data_from_fifo;
      //sc_core::sc_signal<bool> empty_from_fifo;
      //sc_core::sc_signal<bool> one_d_from_fifo;

      fifo<data_width_g, depth_g> _fifo;

   };

}
}

#endif


// Local Variables:
// mode: c++
// c-file-style: "ellemtel"
// c-basic-offset: 3
// End:
