/**
 *
 * @file crossbar_with_pkt_codec_top.hh
 * @author Lasse Lehtonen
 *
 * @brief Foreign module declaration for crossbar_with_pkt_codec_top
 *
 */

/*
 * Copyright 2010 Tampere University of Technology
 * 
 *  This file is part of Transaction Generator.
 *
 *  Transaction Generator is free software: you can redistribute it
 *  and/or modify it under the terms of the Lesser GNU General Public
 *  License as published by the Free Software Foundation, either
 *  version 3 of the License, or (at your option) any later version.
 *
 *  Transaction Generator is distributed in the hope that it will be
 *  useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public
 *  License along with Transaction Generator.  If not, see
 *  <http://www.gnu.org/licenses/>.
 */

/*
 * $Id: crossbar_with_pkt_codec_top.hh 1956 2011-08-22 14:41:32Z lehton87 $
 *
 */


#ifndef SCTG_VHD_CROSSBAR_WITH_PKT_CODEC_TOP_HH
#define SCTG_VHD_CROSSBAR_WITH_PKT_CODEC_TOP_HH

#include <systemc>

namespace sctg
{
namespace crossbar_vhd
{

   template < int n_ag_g,
	      int data_width_g,  
	      int tx_len_width_g >
   class crossbar_with_pkt_codec_top : public sc_core::sc_foreign_module
   {
   public:
      sc_core::sc_in_clk clk_net;
      sc_core::sc_in_clk clk_ip;
      sc_core::sc_in<sc_dt::sc_logic> rst_n;
      sc_core::sc_in<sc_dt::sc_lv<n_ag_g - 1 + 1> > tx_av_in;
      sc_core::sc_in<sc_dt::sc_lv<n_ag_g * data_width_g - 1 + 1> > tx_data_in;
      sc_core::sc_in<sc_dt::sc_lv<n_ag_g - 1 + 1> > tx_we_in;
      sc_core::sc_in<sc_dt::sc_lv<n_ag_g * tx_len_width_g - 1 + 1> > tx_txlen_in;
      sc_core::sc_out<sc_dt::sc_lv<n_ag_g - 1 + 1> > tx_full_out;
      sc_core::sc_out<sc_dt::sc_lv<n_ag_g - 1 + 1> > tx_empty_out;
      sc_core::sc_out<sc_dt::sc_lv<n_ag_g - 1 + 1> > rx_av_out;
      sc_core::sc_out<sc_dt::sc_lv<n_ag_g * data_width_g - 1 + 1> > rx_data_out;
      sc_core::sc_in<sc_dt::sc_lv<n_ag_g - 1 + 1> > rx_re_in;
      sc_core::sc_out<sc_dt::sc_lv<n_ag_g - 1 + 1> > rx_empty_out;
  
  
      crossbar_with_pkt_codec_top(sc_core::sc_module_name nm, 
				  const char* hdl_name,
				  int pkt_switch_en_g,
				  int stfwd_en_g,
				  int addr_width_g,
				  int packet_length_g,
				  int timeout_g,
				  int fill_packet_g, 
				  int len_flit_en_g, 
				  int oaddr_flit_en_g, 
//				  int status_en_g, 
				  int fifo_depth_g, 
				  int noc_freq_g, 
				  int ip_freq_g
	 )
	 : sc_foreign_module(nm),
	   clk_net("clk_net"),
	   clk_ip("clk_ip"),
	   rst_n("rst_n"),
	   tx_av_in("tx_av_in"),
	   tx_data_in("tx_data_in"),
	   tx_we_in("tx_we_in"),
	   tx_txlen_in("tx_txlen_in"),
	   tx_full_out("tx_full_out"),
	   tx_empty_out("tx_empty_out"),
	   rx_av_out("rx_av_out"),
	   rx_data_out("rx_data_out"),
	   rx_re_in("rx_re_in"),
	   rx_empty_out("rx_empty_out")
      {
	 this->add_parameter("n_ag_g", n_ag_g);
	 this->add_parameter("pkt_switch_en_g", pkt_switch_en_g);
	 this->add_parameter("stfwd_en_g", stfwd_en_g);
	 this->add_parameter("data_width_g", data_width_g);
	 this->add_parameter("addr_width_g", addr_width_g);
	 this->add_parameter("packet_length_g", packet_length_g);
	 this->add_parameter("tx_len_width_g", tx_len_width_g);
	 this->add_parameter("timeout_g", timeout_g);
	 this->add_parameter("fill_packet_g", fill_packet_g);
	 this->add_parameter("lut_en_g", 0);
	 this->add_parameter("net_type_g", 3);
	 this->add_parameter("len_flit_en_g", len_flit_en_g);
	 this->add_parameter("oaddr_flit_en_g", oaddr_flit_en_g);
	 this->add_parameter("status_en_g", 0);
	 this->add_parameter("fifo_depth_g", fifo_depth_g);
	 this->add_parameter("net_freq_g", noc_freq_g);
	 this->add_parameter("ip_freq_g", ip_freq_g);
	 elaborate_foreign_module(hdl_name);
      }
  
      ~crossbar_with_pkt_codec_top()
      {}
  
   };

}
}

#endif


// Local Variables:
// mode: c++
// c-file-style: "ellemtel"
// c-basic-offset: 3
// End:
